/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse;

public class ListPoliciesForTargetPublisher
implements SdkPublisher<ListPoliciesForTargetResponse> {
    private final OrganizationsAsyncClient client;
    private final ListPoliciesForTargetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPoliciesForTargetPublisher(OrganizationsAsyncClient client, ListPoliciesForTargetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPoliciesForTargetPublisher(OrganizationsAsyncClient client, ListPoliciesForTargetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPoliciesForTargetResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPoliciesForTargetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPoliciesForTargetResponseFetcher
    implements AsyncPageFetcher<ListPoliciesForTargetResponse> {
        private ListPoliciesForTargetResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesForTargetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPoliciesForTargetResponse> nextPage(ListPoliciesForTargetResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesForTargetPublisher.this.client.listPoliciesForTarget(ListPoliciesForTargetPublisher.this.firstRequest);
            }
            return ListPoliciesForTargetPublisher.this.client.listPoliciesForTarget((ListPoliciesForTargetRequest)((Object)ListPoliciesForTargetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

