/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains rules to be applied to the affected accounts. Policies can be attached directly to accounts, or to roots and
 * OUs to affect all accounts in those hierarchies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Policy implements SdkPojo, Serializable, ToCopyableBuilder<Policy.Builder, Policy> {
    private static final SdkField<PolicySummary> POLICY_SUMMARY_FIELD = SdkField
            .<PolicySummary> builder(MarshallingType.SDK_POJO).memberName("PolicySummary").getter(getter(Policy::policySummary))
            .setter(setter(Builder::policySummary)).constructor(PolicySummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicySummary").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(Policy::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_SUMMARY_FIELD,
            CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final PolicySummary policySummary;

    private final String content;

    private Policy(BuilderImpl builder) {
        this.policySummary = builder.policySummary;
        this.content = builder.content;
    }

    /**
     * <p>
     * A structure that contains additional details about the policy.
     * </p>
     * 
     * @return A structure that contains additional details about the policy.
     */
    public final PolicySummary policySummary() {
        return policySummary;
    }

    /**
     * <p>
     * The text content of the policy.
     * </p>
     * 
     * @return The text content of the policy.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policySummary());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy) obj;
        return Objects.equals(policySummary(), other.policySummary()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Policy").add("PolicySummary", policySummary()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicySummary":
            return Optional.ofNullable(clazz.cast(policySummary()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Policy, T> g) {
        return obj -> g.apply((Policy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Policy> {
        /**
         * <p>
         * A structure that contains additional details about the policy.
         * </p>
         * 
         * @param policySummary
         *        A structure that contains additional details about the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policySummary(PolicySummary policySummary);

        /**
         * <p>
         * A structure that contains additional details about the policy.
         * </p>
         * This is a convenience that creates an instance of the {@link PolicySummary.Builder} avoiding the need to
         * create one manually via {@link PolicySummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicySummary.Builder#build()} is called immediately and its
         * result is passed to {@link #policySummary(PolicySummary)}.
         * 
         * @param policySummary
         *        a consumer that will call methods on {@link PolicySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policySummary(PolicySummary)
         */
        default Builder policySummary(Consumer<PolicySummary.Builder> policySummary) {
            return policySummary(PolicySummary.builder().applyMutation(policySummary).build());
        }

        /**
         * <p>
         * The text content of the policy.
         * </p>
         * 
         * @param content
         *        The text content of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);
    }

    static final class BuilderImpl implements Builder {
        private PolicySummary policySummary;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            policySummary(model.policySummary);
            content(model.content);
        }

        public final PolicySummary.Builder getPolicySummary() {
            return policySummary != null ? policySummary.toBuilder() : null;
        }

        @Override
        public final Builder policySummary(PolicySummary policySummary) {
            this.policySummary = policySummary;
            return this;
        }

        public final void setPolicySummary(PolicySummary.BuilderImpl policySummary) {
            this.policySummary = policySummary != null ? policySummary.build() : null;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public Policy build() {
            return new Policy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
