/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the AWS service for which the account is a delegated administrator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DelegatedService implements SdkPojo, Serializable,
        ToCopyableBuilder<DelegatedService.Builder, DelegatedService> {
    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServicePrincipal").getter(getter(DelegatedService::servicePrincipal))
            .setter(setter(Builder::servicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal").build()).build();

    private static final SdkField<Instant> DELEGATION_ENABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DelegationEnabledDate").getter(getter(DelegatedService::delegationEnabledDate))
            .setter(setter(Builder::delegationEnabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationEnabledDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_PRINCIPAL_FIELD,
            DELEGATION_ENABLED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String servicePrincipal;

    private final Instant delegationEnabledDate;

    private DelegatedService(BuilderImpl builder) {
        this.servicePrincipal = builder.servicePrincipal;
        this.delegationEnabledDate = builder.delegationEnabledDate;
    }

    /**
     * <p>
     * The name of a service that can request an operation for the specified service. This is typically in the form of a
     * URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.
     * </p>
     * 
     * @return The name of a service that can request an operation for the specified service. This is typically in the
     *         form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.
     */
    public final String servicePrincipal() {
        return servicePrincipal;
    }

    /**
     * <p>
     * The date that the account became a delegated administrator for this service.
     * </p>
     * 
     * @return The date that the account became a delegated administrator for this service.
     */
    public final Instant delegationEnabledDate() {
        return delegationEnabledDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(delegationEnabledDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegatedService)) {
            return false;
        }
        DelegatedService other = (DelegatedService) obj;
        return Objects.equals(servicePrincipal(), other.servicePrincipal())
                && Objects.equals(delegationEnabledDate(), other.delegationEnabledDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DelegatedService").add("ServicePrincipal", servicePrincipal())
                .add("DelegationEnabledDate", delegationEnabledDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServicePrincipal":
            return Optional.ofNullable(clazz.cast(servicePrincipal()));
        case "DelegationEnabledDate":
            return Optional.ofNullable(clazz.cast(delegationEnabledDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DelegatedService, T> g) {
        return obj -> g.apply((DelegatedService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DelegatedService> {
        /**
         * <p>
         * The name of a service that can request an operation for the specified service. This is typically in the form
         * of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.
         * </p>
         * 
         * @param servicePrincipal
         *        The name of a service that can request an operation for the specified service. This is typically in
         *        the form of a URL, such as: <code> <i>servicename</i>.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(String servicePrincipal);

        /**
         * <p>
         * The date that the account became a delegated administrator for this service.
         * </p>
         * 
         * @param delegationEnabledDate
         *        The date that the account became a delegated administrator for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationEnabledDate(Instant delegationEnabledDate);
    }

    static final class BuilderImpl implements Builder {
        private String servicePrincipal;

        private Instant delegationEnabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegatedService model) {
            servicePrincipal(model.servicePrincipal);
            delegationEnabledDate(model.delegationEnabledDate);
        }

        public final String getServicePrincipal() {
            return servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        public final Instant getDelegationEnabledDate() {
            return delegationEnabledDate;
        }

        @Override
        public final Builder delegationEnabledDate(Instant delegationEnabledDate) {
            this.delegationEnabledDate = delegationEnabledDate;
            return this;
        }

        public final void setDelegationEnabledDate(Instant delegationEnabledDate) {
            this.delegationEnabledDate = delegationEnabledDate;
        }

        @Override
        public DelegatedService build() {
            return new DelegatedService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
