/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.Organization;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationResponse> {
    private static final SdkField<Organization> ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Organization").getter(DescribeOrganizationResponse.getter(DescribeOrganizationResponse::organization)).setter(DescribeOrganizationResponse.setter(Builder::organization)).constructor(Organization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Organization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_FIELD));
    private final Organization organization;

    private DescribeOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.organization = builder.organization;
    }

    public final Organization organization() {
        return this.organization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationResponse)) {
            return false;
        }
        DescribeOrganizationResponse other = (DescribeOrganizationResponse)((Object)obj);
        return Objects.equals(this.organization(), other.organization());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationResponse").add("Organization", (Object)this.organization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Organization": {
                return Optional.ofNullable(clazz.cast(this.organization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private Organization organization;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationResponse model) {
            super(model);
            this.organization(model.organization);
        }

        public final Organization.Builder getOrganization() {
            return this.organization != null ? this.organization.toBuilder() : null;
        }

        @Override
        public final Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public final void setOrganization(Organization.BuilderImpl organization) {
            this.organization = organization != null ? organization.build() : null;
        }

        @Override
        public DescribeOrganizationResponse build() {
            return new DescribeOrganizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationResponse> {
        public Builder organization(Organization var1);

        default public Builder organization(Consumer<Organization.Builder> organization) {
            return this.organization((Organization)((Organization.Builder)Organization.builder().applyMutation(organization)).build());
        }
    }
}

