/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatus;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatusesCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCreateAccountStatusResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListCreateAccountStatusResponse> {
    private static final SdkField<List<CreateAccountStatus>> CREATE_ACCOUNT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreateAccountStatuses").getter(ListCreateAccountStatusResponse.getter(ListCreateAccountStatusResponse::createAccountStatuses)).setter(ListCreateAccountStatusResponse.setter(Builder::createAccountStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAccountStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateAccountStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCreateAccountStatusResponse.getter(ListCreateAccountStatusResponse::nextToken)).setter(ListCreateAccountStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_ACCOUNT_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private final List<CreateAccountStatus> createAccountStatuses;
    private final String nextToken;

    private ListCreateAccountStatusResponse(BuilderImpl builder) {
        super(builder);
        this.createAccountStatuses = builder.createAccountStatuses;
        this.nextToken = builder.nextToken;
    }

    public boolean hasCreateAccountStatuses() {
        return this.createAccountStatuses != null && !(this.createAccountStatuses instanceof SdkAutoConstructList);
    }

    public List<CreateAccountStatus> createAccountStatuses() {
        return this.createAccountStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateAccountStatuses() ? this.createAccountStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCreateAccountStatusResponse)) {
            return false;
        }
        ListCreateAccountStatusResponse other = (ListCreateAccountStatusResponse)((Object)obj);
        return this.hasCreateAccountStatuses() == other.hasCreateAccountStatuses() && Objects.equals(this.createAccountStatuses(), other.createAccountStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCreateAccountStatusResponse").add("CreateAccountStatuses", this.hasCreateAccountStatuses() ? this.createAccountStatuses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateAccountStatuses": {
                return Optional.ofNullable(clazz.cast(this.createAccountStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCreateAccountStatusResponse, T> g) {
        return obj -> g.apply((ListCreateAccountStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<CreateAccountStatus> createAccountStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCreateAccountStatusResponse model) {
            super(model);
            this.createAccountStatuses(model.createAccountStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<CreateAccountStatus.Builder> getCreateAccountStatuses() {
            if (this.createAccountStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.createAccountStatuses != null ? (Collection)this.createAccountStatuses.stream().map(CreateAccountStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createAccountStatuses(Collection<CreateAccountStatus> createAccountStatuses) {
            this.createAccountStatuses = CreateAccountStatusesCopier.copy(createAccountStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createAccountStatuses(CreateAccountStatus ... createAccountStatuses) {
            this.createAccountStatuses(Arrays.asList(createAccountStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createAccountStatuses(Consumer<CreateAccountStatus.Builder> ... createAccountStatuses) {
            this.createAccountStatuses(Stream.of(createAccountStatuses).map(c -> (CreateAccountStatus)((CreateAccountStatus.Builder)CreateAccountStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateAccountStatuses(Collection<CreateAccountStatus.BuilderImpl> createAccountStatuses) {
            this.createAccountStatuses = CreateAccountStatusesCopier.copyFromBuilder(createAccountStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCreateAccountStatusResponse build() {
            return new ListCreateAccountStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCreateAccountStatusResponse> {
        public Builder createAccountStatuses(Collection<CreateAccountStatus> var1);

        public Builder createAccountStatuses(CreateAccountStatus ... var1);

        public Builder createAccountStatuses(Consumer<CreateAccountStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

