/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.DelegatedAdministrator;
import software.amazon.awssdk.services.organizations.model.DelegatedAdministratorsCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDelegatedAdministratorsResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListDelegatedAdministratorsResponse> {
    private static final SdkField<List<DelegatedAdministrator>> DELEGATED_ADMINISTRATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DelegatedAdministrators").getter(ListDelegatedAdministratorsResponse.getter(ListDelegatedAdministratorsResponse::delegatedAdministrators)).setter(ListDelegatedAdministratorsResponse.setter(Builder::delegatedAdministrators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegatedAdministrators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DelegatedAdministrator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDelegatedAdministratorsResponse.getter(ListDelegatedAdministratorsResponse::nextToken)).setter(ListDelegatedAdministratorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATED_ADMINISTRATORS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DelegatedAdministrator> delegatedAdministrators;
    private final String nextToken;

    private ListDelegatedAdministratorsResponse(BuilderImpl builder) {
        super(builder);
        this.delegatedAdministrators = builder.delegatedAdministrators;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDelegatedAdministrators() {
        return this.delegatedAdministrators != null && !(this.delegatedAdministrators instanceof SdkAutoConstructList);
    }

    public List<DelegatedAdministrator> delegatedAdministrators() {
        return this.delegatedAdministrators;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.delegatedAdministrators());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDelegatedAdministratorsResponse)) {
            return false;
        }
        ListDelegatedAdministratorsResponse other = (ListDelegatedAdministratorsResponse)((Object)obj);
        return Objects.equals(this.delegatedAdministrators(), other.delegatedAdministrators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDelegatedAdministratorsResponse").add("DelegatedAdministrators", this.delegatedAdministrators()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DelegatedAdministrators": {
                return Optional.ofNullable(clazz.cast(this.delegatedAdministrators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDelegatedAdministratorsResponse, T> g) {
        return obj -> g.apply((ListDelegatedAdministratorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<DelegatedAdministrator> delegatedAdministrators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDelegatedAdministratorsResponse model) {
            super(model);
            this.delegatedAdministrators(model.delegatedAdministrators);
            this.nextToken(model.nextToken);
        }

        public final Collection<DelegatedAdministrator.Builder> getDelegatedAdministrators() {
            return this.delegatedAdministrators != null ? (Collection)this.delegatedAdministrators.stream().map(DelegatedAdministrator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder delegatedAdministrators(Collection<DelegatedAdministrator> delegatedAdministrators) {
            this.delegatedAdministrators = DelegatedAdministratorsCopier.copy(delegatedAdministrators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegatedAdministrators(DelegatedAdministrator ... delegatedAdministrators) {
            this.delegatedAdministrators(Arrays.asList(delegatedAdministrators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegatedAdministrators(Consumer<DelegatedAdministrator.Builder> ... delegatedAdministrators) {
            this.delegatedAdministrators(Stream.of(delegatedAdministrators).map(c -> (DelegatedAdministrator)((DelegatedAdministrator.Builder)DelegatedAdministrator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDelegatedAdministrators(Collection<DelegatedAdministrator.BuilderImpl> delegatedAdministrators) {
            this.delegatedAdministrators = DelegatedAdministratorsCopier.copyFromBuilder(delegatedAdministrators);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDelegatedAdministratorsResponse build() {
            return new ListDelegatedAdministratorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDelegatedAdministratorsResponse> {
        public Builder delegatedAdministrators(Collection<DelegatedAdministrator> var1);

        public Builder delegatedAdministrators(DelegatedAdministrator ... var1);

        public Builder delegatedAdministrators(Consumer<DelegatedAdministrator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

