/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.EffectivePolicyType;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEffectivePolicyRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, DescribeEffectivePolicyRequest> {
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEffectivePolicyRequest.getter(DescribeEffectivePolicyRequest::policyTypeAsString)).setter(DescribeEffectivePolicyRequest.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEffectivePolicyRequest.getter(DescribeEffectivePolicyRequest::targetId)).setter(DescribeEffectivePolicyRequest.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_FIELD, TARGET_ID_FIELD));
    private final String policyType;
    private final String targetId;

    private DescribeEffectivePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyType = builder.policyType;
        this.targetId = builder.targetId;
    }

    public EffectivePolicyType policyType() {
        return EffectivePolicyType.fromValue(this.policyType);
    }

    public String policyTypeAsString() {
        return this.policyType;
    }

    public String targetId() {
        return this.targetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEffectivePolicyRequest)) {
            return false;
        }
        DescribeEffectivePolicyRequest other = (DescribeEffectivePolicyRequest)((Object)obj);
        return Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.targetId(), other.targetId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEffectivePolicyRequest").add("PolicyType", (Object)this.policyTypeAsString()).add("TargetId", (Object)this.targetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEffectivePolicyRequest, T> g) {
        return obj -> g.apply((DescribeEffectivePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private String policyType;
        private String targetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEffectivePolicyRequest model) {
            super(model);
            this.policyType(model.policyType);
            this.targetId(model.targetId);
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(EffectivePolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEffectivePolicyRequest build() {
            return new DescribeEffectivePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEffectivePolicyRequest> {
        public Builder policyType(String var1);

        public Builder policyType(EffectivePolicyType var1);

        public Builder targetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

