/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.Handshake;
import software.amazon.awssdk.services.organizations.model.HandshakesCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHandshakesForAccountResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListHandshakesForAccountResponse> {
    private static final SdkField<List<Handshake>> HANDSHAKES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListHandshakesForAccountResponse.getter(ListHandshakesForAccountResponse::handshakes)).setter(ListHandshakesForAccountResponse.setter(Builder::handshakes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handshakes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Handshake::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListHandshakesForAccountResponse.getter(ListHandshakesForAccountResponse::nextToken)).setter(ListHandshakesForAccountResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HANDSHAKES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Handshake> handshakes;
    private final String nextToken;

    private ListHandshakesForAccountResponse(BuilderImpl builder) {
        super(builder);
        this.handshakes = builder.handshakes;
        this.nextToken = builder.nextToken;
    }

    public boolean hasHandshakes() {
        return this.handshakes != null && !(this.handshakes instanceof SdkAutoConstructList);
    }

    public List<Handshake> handshakes() {
        return this.handshakes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.handshakes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHandshakesForAccountResponse)) {
            return false;
        }
        ListHandshakesForAccountResponse other = (ListHandshakesForAccountResponse)((Object)obj);
        return Objects.equals(this.handshakes(), other.handshakes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListHandshakesForAccountResponse").add("Handshakes", this.handshakes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Handshakes": {
                return Optional.ofNullable(clazz.cast(this.handshakes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHandshakesForAccountResponse, T> g) {
        return obj -> g.apply((ListHandshakesForAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<Handshake> handshakes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHandshakesForAccountResponse model) {
            super(model);
            this.handshakes(model.handshakes);
            this.nextToken(model.nextToken);
        }

        public final Collection<Handshake.Builder> getHandshakes() {
            return this.handshakes != null ? (Collection)this.handshakes.stream().map(Handshake::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder handshakes(Collection<Handshake> handshakes) {
            this.handshakes = HandshakesCopier.copy(handshakes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder handshakes(Handshake ... handshakes) {
            this.handshakes(Arrays.asList(handshakes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder handshakes(Consumer<Handshake.Builder> ... handshakes) {
            this.handshakes(Stream.of(handshakes).map(c -> (Handshake)((Handshake.Builder)Handshake.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHandshakes(Collection<Handshake.BuilderImpl> handshakes) {
            this.handshakes = HandshakesCopier.copyFromBuilder(handshakes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHandshakesForAccountResponse build() {
            return new ListHandshakesForAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHandshakesForAccountResponse> {
        public Builder handshakes(Collection<Handshake> var1);

        public Builder handshakes(Handshake ... var1);

        public Builder handshakes(Consumer<Handshake.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

