/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListAccountsRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsResponse;

public class ListAccountsIterable
implements SdkIterable<ListAccountsResponse> {
    private final OrganizationsClient client;
    private final ListAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountsIterable(OrganizationsClient client, ListAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountsResponseFetcher();
    }

    public Iterator<ListAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAccountsResponseFetcher
    implements SyncPageFetcher<ListAccountsResponse> {
        private ListAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountsResponse nextPage(ListAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsIterable.this.client.listAccounts(ListAccountsIterable.this.firstRequest);
            }
            return ListAccountsIterable.this.client.listAccounts((ListAccountsRequest)((Object)ListAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

