/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDelegatedServicesForAccountResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListDelegatedServicesForAccountResponse.Builder, ListDelegatedServicesForAccountResponse> {
    private static final SdkField<List<DelegatedService>> DELEGATED_SERVICES_FIELD = SdkField
            .<List<DelegatedService>> builder(MarshallingType.LIST)
            .getter(getter(ListDelegatedServicesForAccountResponse::delegatedServices))
            .setter(setter(Builder::delegatedServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegatedServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DelegatedService> builder(MarshallingType.SDK_POJO)
                                            .constructor(DelegatedService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDelegatedServicesForAccountResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATED_SERVICES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DelegatedService> delegatedServices;

    private final String nextToken;

    private ListDelegatedServicesForAccountResponse(BuilderImpl builder) {
        super(builder);
        this.delegatedServices = builder.delegatedServices;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DelegatedServices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDelegatedServices() {
        return delegatedServices != null && !(delegatedServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The services for which the account is a delegated administrator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDelegatedServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The services for which the account is a delegated administrator.
     */
    public List<DelegatedService> delegatedServices() {
        return delegatedServices;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(delegatedServices());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDelegatedServicesForAccountResponse)) {
            return false;
        }
        ListDelegatedServicesForAccountResponse other = (ListDelegatedServicesForAccountResponse) obj;
        return Objects.equals(delegatedServices(), other.delegatedServices()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDelegatedServicesForAccountResponse").add("DelegatedServices", delegatedServices())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DelegatedServices":
            return Optional.ofNullable(clazz.cast(delegatedServices()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDelegatedServicesForAccountResponse, T> g) {
        return obj -> g.apply((ListDelegatedServicesForAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDelegatedServicesForAccountResponse> {
        /**
         * <p>
         * The services for which the account is a delegated administrator.
         * </p>
         * 
         * @param delegatedServices
         *        The services for which the account is a delegated administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegatedServices(Collection<DelegatedService> delegatedServices);

        /**
         * <p>
         * The services for which the account is a delegated administrator.
         * </p>
         * 
         * @param delegatedServices
         *        The services for which the account is a delegated administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegatedServices(DelegatedService... delegatedServices);

        /**
         * <p>
         * The services for which the account is a delegated administrator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DelegatedService>.Builder} avoiding the
         * need to create one manually via {@link List<DelegatedService>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DelegatedService>.Builder#build()} is called immediately and
         * its result is passed to {@link #delegatedServices(List<DelegatedService>)}.
         * 
         * @param delegatedServices
         *        a consumer that will call methods on {@link List<DelegatedService>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegatedServices(List<DelegatedService>)
         */
        Builder delegatedServices(Consumer<DelegatedService.Builder>... delegatedServices);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private List<DelegatedService> delegatedServices = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDelegatedServicesForAccountResponse model) {
            super(model);
            delegatedServices(model.delegatedServices);
            nextToken(model.nextToken);
        }

        public final Collection<DelegatedService.Builder> getDelegatedServices() {
            return delegatedServices != null ? delegatedServices.stream().map(DelegatedService::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder delegatedServices(Collection<DelegatedService> delegatedServices) {
            this.delegatedServices = DelegatedServicesCopier.copy(delegatedServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegatedServices(DelegatedService... delegatedServices) {
            delegatedServices(Arrays.asList(delegatedServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegatedServices(Consumer<DelegatedService.Builder>... delegatedServices) {
            delegatedServices(Stream.of(delegatedServices).map(c -> DelegatedService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDelegatedServices(Collection<DelegatedService.BuilderImpl> delegatedServices) {
            this.delegatedServices = DelegatedServicesCopier.copyFromBuilder(delegatedServices);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDelegatedServicesForAccountResponse build() {
            return new ListDelegatedServicesForAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
