/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationResponse extends OrganizationsResponse implements
        ToCopyableBuilder<DescribeOrganizationResponse.Builder, DescribeOrganizationResponse> {
    private static final SdkField<Organization> ORGANIZATION_FIELD = SdkField.<Organization> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeOrganizationResponse::organization)).setter(setter(Builder::organization))
            .constructor(Organization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Organization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_FIELD));

    private final Organization organization;

    private DescribeOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.organization = builder.organization;
    }

    /**
     * <p>
     * A structure that contains information about the organization.
     * </p>
     * 
     * @return A structure that contains information about the organization.
     */
    public Organization organization() {
        return organization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationResponse)) {
            return false;
        }
        DescribeOrganizationResponse other = (DescribeOrganizationResponse) obj;
        return Objects.equals(organization(), other.organization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOrganizationResponse").add("Organization", organization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Organization":
            return Optional.ofNullable(clazz.cast(organization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationResponse> {
        /**
         * <p>
         * A structure that contains information about the organization.
         * </p>
         * 
         * @param organization
         *        A structure that contains information about the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organization(Organization organization);

        /**
         * <p>
         * A structure that contains information about the organization.
         * </p>
         * This is a convenience that creates an instance of the {@link Organization.Builder} avoiding the need to
         * create one manually via {@link Organization#builder()}.
         *
         * When the {@link Consumer} completes, {@link Organization.Builder#build()} is called immediately and its
         * result is passed to {@link #organization(Organization)}.
         * 
         * @param organization
         *        a consumer that will call methods on {@link Organization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organization(Organization)
         */
        default Builder organization(Consumer<Organization.Builder> organization) {
            return organization(Organization.builder().applyMutation(organization).build());
        }
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private Organization organization;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationResponse model) {
            super(model);
            organization(model.organization);
        }

        public final Organization.Builder getOrganization() {
            return organization != null ? organization.toBuilder() : null;
        }

        @Override
        public final Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public final void setOrganization(Organization.BuilderImpl organization) {
            this.organization = organization != null ? organization.build() : null;
        }

        @Override
        public DescribeOrganizationResponse build() {
            return new DescribeOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
