/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InviteAccountToOrganizationRequest extends OrganizationsRequest implements
        ToCopyableBuilder<InviteAccountToOrganizationRequest.Builder, InviteAccountToOrganizationRequest> {
    private static final SdkField<HandshakeParty> TARGET_FIELD = SdkField.<HandshakeParty> builder(MarshallingType.SDK_POJO)
            .getter(getter(InviteAccountToOrganizationRequest::target)).setter(setter(Builder::target))
            .constructor(HandshakeParty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InviteAccountToOrganizationRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, NOTES_FIELD));

    private final HandshakeParty target;

    private final String notes;

    private InviteAccountToOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.target = builder.target;
        this.notes = builder.notes;
    }

    /**
     * <p>
     * The identifier (ID) of the AWS account that you want to invite to join your organization. This is a JSON object
     * that contains the following elements:
     * </p>
     * <p>
     * <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
     * </p>
     * <p>
     * If you use the AWS CLI, you can submit this as a single string, similar to the following example:
     * </p>
     * <p>
     * <code>--target Id=123456789012,Type=ACCOUNT</code>
     * </p>
     * <p>
     * If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID number as the <code>Id</code>.
     * If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is associated with the
     * account.
     * </p>
     * <p>
     * <code>--target Id=diego@example.com,Type=EMAIL</code>
     * </p>
     * 
     * @return The identifier (ID) of the AWS account that you want to invite to join your organization. This is a JSON
     *         object that contains the following elements: </p>
     *         <p>
     *         <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
     *         </p>
     *         <p>
     *         If you use the AWS CLI, you can submit this as a single string, similar to the following example:
     *         </p>
     *         <p>
     *         <code>--target Id=123456789012,Type=ACCOUNT</code>
     *         </p>
     *         <p>
     *         If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID number as the
     *         <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is
     *         associated with the account.
     *         </p>
     *         <p>
     *         <code>--target Id=diego@example.com,Type=EMAIL</code>
     */
    public HandshakeParty target() {
        return target;
    }

    /**
     * <p>
     * Additional information that you want to include in the generated email to the recipient account owner.
     * </p>
     * 
     * @return Additional information that you want to include in the generated email to the recipient account owner.
     */
    public String notes() {
        return notes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InviteAccountToOrganizationRequest)) {
            return false;
        }
        InviteAccountToOrganizationRequest other = (InviteAccountToOrganizationRequest) obj;
        return Objects.equals(target(), other.target()) && Objects.equals(notes(), other.notes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InviteAccountToOrganizationRequest").add("Target", target())
                .add("Notes", notes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InviteAccountToOrganizationRequest, T> g) {
        return obj -> g.apply((InviteAccountToOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InviteAccountToOrganizationRequest> {
        /**
         * <p>
         * The identifier (ID) of the AWS account that you want to invite to join your organization. This is a JSON
         * object that contains the following elements:
         * </p>
         * <p>
         * <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
         * </p>
         * <p>
         * If you use the AWS CLI, you can submit this as a single string, similar to the following example:
         * </p>
         * <p>
         * <code>--target Id=123456789012,Type=ACCOUNT</code>
         * </p>
         * <p>
         * If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID number as the
         * <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is
         * associated with the account.
         * </p>
         * <p>
         * <code>--target Id=diego@example.com,Type=EMAIL</code>
         * </p>
         * 
         * @param target
         *        The identifier (ID) of the AWS account that you want to invite to join your organization. This is a
         *        JSON object that contains the following elements: </p>
         *        <p>
         *        <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
         *        </p>
         *        <p>
         *        If you use the AWS CLI, you can submit this as a single string, similar to the following example:
         *        </p>
         *        <p>
         *        <code>--target Id=123456789012,Type=ACCOUNT</code>
         *        </p>
         *        <p>
         *        If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID number as the
         *        <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that
         *        is associated with the account.
         *        </p>
         *        <p>
         *        <code>--target Id=diego@example.com,Type=EMAIL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(HandshakeParty target);

        /**
         * <p>
         * The identifier (ID) of the AWS account that you want to invite to join your organization. This is a JSON
         * object that contains the following elements:
         * </p>
         * <p>
         * <code>{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" }</code>
         * </p>
         * <p>
         * If you use the AWS CLI, you can submit this as a single string, similar to the following example:
         * </p>
         * <p>
         * <code>--target Id=123456789012,Type=ACCOUNT</code>
         * </p>
         * <p>
         * If you specify <code>"Type": "ACCOUNT"</code>, you must provide the AWS account ID number as the
         * <code>Id</code>. If you specify <code>"Type": "EMAIL"</code>, you must specify the email address that is
         * associated with the account.
         * </p>
         * <p>
         * <code>--target Id=diego@example.com,Type=EMAIL</code>
         * </p>
         * This is a convenience that creates an instance of the {@link HandshakeParty.Builder} avoiding the need to
         * create one manually via {@link HandshakeParty#builder()}.
         *
         * When the {@link Consumer} completes, {@link HandshakeParty.Builder#build()} is called immediately and its
         * result is passed to {@link #target(HandshakeParty)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link HandshakeParty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(HandshakeParty)
         */
        default Builder target(Consumer<HandshakeParty.Builder> target) {
            return target(HandshakeParty.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * Additional information that you want to include in the generated email to the recipient account owner.
         * </p>
         * 
         * @param notes
         *        Additional information that you want to include in the generated email to the recipient account owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OrganizationsRequest.BuilderImpl implements Builder {
        private HandshakeParty target;

        private String notes;

        private BuilderImpl() {
        }

        private BuilderImpl(InviteAccountToOrganizationRequest model) {
            super(model);
            target(model.target);
            notes(model.notes);
        }

        public final HandshakeParty.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        @Override
        public final Builder target(HandshakeParty target) {
            this.target = target;
            return this;
        }

        public final void setTarget(HandshakeParty.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final String getNotes() {
            return notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InviteAccountToOrganizationRequest build() {
            return new InviteAccountToOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
