/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.OrganizationFeatureSet;
import software.amazon.awssdk.services.organizations.model.PolicyTypeSummary;
import software.amazon.awssdk.services.organizations.model.PolicyTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Organization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Organization> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::id)).setter(Organization.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::arn)).setter(Organization.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> FEATURE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::featureSetAsString)).setter(Organization.setter(Builder::featureSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureSet").build()}).build();
    private static final SdkField<String> MASTER_ACCOUNT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::masterAccountArn)).setter(Organization.setter(Builder::masterAccountArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterAccountArn").build()}).build();
    private static final SdkField<String> MASTER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::masterAccountId)).setter(Organization.setter(Builder::masterAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterAccountId").build()}).build();
    private static final SdkField<String> MASTER_ACCOUNT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::masterAccountEmail)).setter(Organization.setter(Builder::masterAccountEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterAccountEmail").build()}).build();
    private static final SdkField<List<PolicyTypeSummary>> AVAILABLE_POLICY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Organization.getter(Organization::availablePolicyTypes)).setter(Organization.setter(Builder::availablePolicyTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailablePolicyTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyTypeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, FEATURE_SET_FIELD, MASTER_ACCOUNT_ARN_FIELD, MASTER_ACCOUNT_ID_FIELD, MASTER_ACCOUNT_EMAIL_FIELD, AVAILABLE_POLICY_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String featureSet;
    private final String masterAccountArn;
    private final String masterAccountId;
    private final String masterAccountEmail;
    private final List<PolicyTypeSummary> availablePolicyTypes;

    private Organization(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.featureSet = builder.featureSet;
        this.masterAccountArn = builder.masterAccountArn;
        this.masterAccountId = builder.masterAccountId;
        this.masterAccountEmail = builder.masterAccountEmail;
        this.availablePolicyTypes = builder.availablePolicyTypes;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public OrganizationFeatureSet featureSet() {
        return OrganizationFeatureSet.fromValue(this.featureSet);
    }

    public String featureSetAsString() {
        return this.featureSet;
    }

    public String masterAccountArn() {
        return this.masterAccountArn;
    }

    public String masterAccountId() {
        return this.masterAccountId;
    }

    public String masterAccountEmail() {
        return this.masterAccountEmail;
    }

    public boolean hasAvailablePolicyTypes() {
        return this.availablePolicyTypes != null && !(this.availablePolicyTypes instanceof SdkAutoConstructList);
    }

    public List<PolicyTypeSummary> availablePolicyTypes() {
        return this.availablePolicyTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterAccountArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterAccountEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.availablePolicyTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Organization)) {
            return false;
        }
        Organization other = (Organization)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.featureSetAsString(), other.featureSetAsString()) && Objects.equals(this.masterAccountArn(), other.masterAccountArn()) && Objects.equals(this.masterAccountId(), other.masterAccountId()) && Objects.equals(this.masterAccountEmail(), other.masterAccountEmail()) && Objects.equals(this.availablePolicyTypes(), other.availablePolicyTypes());
    }

    public String toString() {
        return ToString.builder((String)"Organization").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("FeatureSet", (Object)this.featureSetAsString()).add("MasterAccountArn", (Object)this.masterAccountArn()).add("MasterAccountId", (Object)this.masterAccountId()).add("MasterAccountEmail", (Object)(this.masterAccountEmail() == null ? null : "*** Sensitive Data Redacted ***")).add("AvailablePolicyTypes", this.availablePolicyTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "FeatureSet": {
                return Optional.ofNullable(clazz.cast(this.featureSetAsString()));
            }
            case "MasterAccountArn": {
                return Optional.ofNullable(clazz.cast(this.masterAccountArn()));
            }
            case "MasterAccountId": {
                return Optional.ofNullable(clazz.cast(this.masterAccountId()));
            }
            case "MasterAccountEmail": {
                return Optional.ofNullable(clazz.cast(this.masterAccountEmail()));
            }
            case "AvailablePolicyTypes": {
                return Optional.ofNullable(clazz.cast(this.availablePolicyTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Organization, T> g) {
        return obj -> g.apply((Organization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String featureSet;
        private String masterAccountArn;
        private String masterAccountId;
        private String masterAccountEmail;
        private List<PolicyTypeSummary> availablePolicyTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Organization model) {
            this.id(model.id);
            this.arn(model.arn);
            this.featureSet(model.featureSet);
            this.masterAccountArn(model.masterAccountArn);
            this.masterAccountId(model.masterAccountId);
            this.masterAccountEmail(model.masterAccountEmail);
            this.availablePolicyTypes(model.availablePolicyTypes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getFeatureSetAsString() {
            return this.featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(OrganizationFeatureSet featureSet) {
            this.featureSet(featureSet == null ? null : featureSet.toString());
            return this;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        public final String getMasterAccountArn() {
            return this.masterAccountArn;
        }

        @Override
        public final Builder masterAccountArn(String masterAccountArn) {
            this.masterAccountArn = masterAccountArn;
            return this;
        }

        public final void setMasterAccountArn(String masterAccountArn) {
            this.masterAccountArn = masterAccountArn;
        }

        public final String getMasterAccountId() {
            return this.masterAccountId;
        }

        @Override
        public final Builder masterAccountId(String masterAccountId) {
            this.masterAccountId = masterAccountId;
            return this;
        }

        public final void setMasterAccountId(String masterAccountId) {
            this.masterAccountId = masterAccountId;
        }

        public final String getMasterAccountEmail() {
            return this.masterAccountEmail;
        }

        @Override
        public final Builder masterAccountEmail(String masterAccountEmail) {
            this.masterAccountEmail = masterAccountEmail;
            return this;
        }

        public final void setMasterAccountEmail(String masterAccountEmail) {
            this.masterAccountEmail = masterAccountEmail;
        }

        public final Collection<PolicyTypeSummary.Builder> getAvailablePolicyTypes() {
            return this.availablePolicyTypes != null ? (Collection)this.availablePolicyTypes.stream().map(PolicyTypeSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availablePolicyTypes(Collection<PolicyTypeSummary> availablePolicyTypes) {
            this.availablePolicyTypes = PolicyTypesCopier.copy(availablePolicyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePolicyTypes(PolicyTypeSummary ... availablePolicyTypes) {
            this.availablePolicyTypes(Arrays.asList(availablePolicyTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePolicyTypes(Consumer<PolicyTypeSummary.Builder> ... availablePolicyTypes) {
            this.availablePolicyTypes(Stream.of(availablePolicyTypes).map(c -> (PolicyTypeSummary)((PolicyTypeSummary.Builder)PolicyTypeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAvailablePolicyTypes(Collection<PolicyTypeSummary.BuilderImpl> availablePolicyTypes) {
            this.availablePolicyTypes = PolicyTypesCopier.copyFromBuilder(availablePolicyTypes);
        }

        public Organization build() {
            return new Organization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Organization> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder featureSet(String var1);

        public Builder featureSet(OrganizationFeatureSet var1);

        public Builder masterAccountArn(String var1);

        public Builder masterAccountId(String var1);

        public Builder masterAccountEmail(String var1);

        public Builder availablePolicyTypes(Collection<PolicyTypeSummary> var1);

        public Builder availablePolicyTypes(PolicyTypeSummary ... var1);

        public Builder availablePolicyTypes(Consumer<PolicyTypeSummary.Builder> ... var1);
    }
}

