/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListRootsRequest;
import software.amazon.awssdk.services.organizations.model.ListRootsResponse;

public class ListRootsPublisher
implements SdkPublisher<ListRootsResponse> {
    private final OrganizationsAsyncClient client;
    private final ListRootsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRootsPublisher(OrganizationsAsyncClient client, ListRootsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRootsPublisher(OrganizationsAsyncClient client, ListRootsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRootsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRootsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListRootsPublisher resume(ListRootsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRootsPublisher(this.client, (ListRootsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListRootsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListRootsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListRootsResponseFetcher
    implements AsyncPageFetcher<ListRootsResponse> {
        private ListRootsResponseFetcher() {
        }

        public boolean hasNextPage(ListRootsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListRootsResponse> nextPage(ListRootsResponse previousPage) {
            if (previousPage == null) {
                return ListRootsPublisher.this.client.listRoots(ListRootsPublisher.this.firstRequest);
            }
            return ListRootsPublisher.this.client.listRoots((ListRootsRequest)((Object)ListRootsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

