/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListPoliciesRequest;
import software.amazon.awssdk.services.organizations.model.ListPoliciesResponse;

public class ListPoliciesPublisher
implements SdkPublisher<ListPoliciesResponse> {
    private final OrganizationsAsyncClient client;
    private final ListPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPoliciesPublisher(OrganizationsAsyncClient client, ListPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPoliciesPublisher(OrganizationsAsyncClient client, ListPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListPoliciesPublisher resume(ListPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPoliciesPublisher(this.client, (ListPoliciesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPoliciesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListPoliciesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListPoliciesResponseFetcher
    implements AsyncPageFetcher<ListPoliciesResponse> {
        private ListPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListPoliciesResponse> nextPage(ListPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesPublisher.this.client.listPolicies(ListPoliciesPublisher.this.firstRequest);
            }
            return ListPoliciesPublisher.this.client.listPolicies((ListPoliciesRequest)((Object)ListPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

