/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListParentsRequest;
import software.amazon.awssdk.services.organizations.model.ListParentsResponse;

public class ListParentsIterable
implements SdkIterable<ListParentsResponse> {
    private final OrganizationsClient client;
    private final ListParentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListParentsIterable(OrganizationsClient client, ListParentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListParentsResponseFetcher();
    }

    public Iterator<ListParentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListParentsIterable resume(ListParentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListParentsIterable(this.client, (ListParentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListParentsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListParentsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListParentsResponseFetcher
    implements SyncPageFetcher<ListParentsResponse> {
        private ListParentsResponseFetcher() {
        }

        public boolean hasNextPage(ListParentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListParentsResponse nextPage(ListParentsResponse previousPage) {
            if (previousPage == null) {
                return ListParentsIterable.this.client.listParents(ListParentsIterable.this.firstRequest);
            }
            return ListParentsIterable.this.client.listParents((ListParentsRequest)((Object)ListParentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

