/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest;
import software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse;

public class ListHandshakesForOrganizationPublisher
implements SdkPublisher<ListHandshakesForOrganizationResponse> {
    private final OrganizationsAsyncClient client;
    private final ListHandshakesForOrganizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHandshakesForOrganizationPublisher(OrganizationsAsyncClient client, ListHandshakesForOrganizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHandshakesForOrganizationPublisher(OrganizationsAsyncClient client, ListHandshakesForOrganizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHandshakesForOrganizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHandshakesForOrganizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListHandshakesForOrganizationPublisher resume(ListHandshakesForOrganizationResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHandshakesForOrganizationPublisher(this.client, (ListHandshakesForOrganizationRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListHandshakesForOrganizationPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListHandshakesForOrganizationResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListHandshakesForOrganizationResponseFetcher
    implements AsyncPageFetcher<ListHandshakesForOrganizationResponse> {
        private ListHandshakesForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListHandshakesForOrganizationResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListHandshakesForOrganizationResponse> nextPage(ListHandshakesForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListHandshakesForOrganizationPublisher.this.client.listHandshakesForOrganization(ListHandshakesForOrganizationPublisher.this.firstRequest);
            }
            return ListHandshakesForOrganizationPublisher.this.client.listHandshakesForOrganization((ListHandshakesForOrganizationRequest)((Object)ListHandshakesForOrganizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

