/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListAccountsRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsResponse;

public class ListAccountsPublisher
implements SdkPublisher<ListAccountsResponse> {
    private final OrganizationsAsyncClient client;
    private final ListAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountsPublisher(OrganizationsAsyncClient client, ListAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountsPublisher(OrganizationsAsyncClient client, ListAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListAccountsPublisher resume(ListAccountsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAccountsPublisher(this.client, (ListAccountsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAccountsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAccountsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAccountsResponseFetcher
    implements AsyncPageFetcher<ListAccountsResponse> {
        private ListAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListAccountsResponse> nextPage(ListAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsPublisher.this.client.listAccounts(ListAccountsPublisher.this.firstRequest);
            }
            return ListAccountsPublisher.this.client.listAccounts((ListAccountsRequest)((Object)ListAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

