/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.organizations.OrganizationsClient;
import software.amazon.awssdk.services.organizations.model.ListAccountsRequest;
import software.amazon.awssdk.services.organizations.model.ListAccountsResponse;

public class ListAccountsIterable
implements SdkIterable<ListAccountsResponse> {
    private final OrganizationsClient client;
    private final ListAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountsIterable(OrganizationsClient client, ListAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountsResponseFetcher();
    }

    public Iterator<ListAccountsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListAccountsIterable resume(ListAccountsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAccountsIterable(this.client, (ListAccountsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAccountsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAccountsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAccountsResponseFetcher
    implements SyncPageFetcher<ListAccountsResponse> {
        private ListAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListAccountsResponse nextPage(ListAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsIterable.this.client.listAccounts(ListAccountsIterable.this.firstRequest);
            }
            return ListAccountsIterable.this.client.listAccounts((ListAccountsRequest)((Object)ListAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

