/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.services.organizations.model.PoliciesCopier;
import software.amazon.awssdk.services.organizations.model.PolicySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPoliciesResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListPoliciesResponse> {
    private final List<PolicySummary> policies;
    private final String nextToken;

    private ListPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policies = builder.policies;
        this.nextToken = builder.nextToken;
    }

    public List<PolicySummary> policies() {
        return this.policies;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesResponse)) {
            return false;
        }
        ListPoliciesResponse other = (ListPoliciesResponse)((Object)obj);
        return Objects.equals(this.policies(), other.policies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPoliciesResponse").add("Policies", this.policies()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policies": {
                return Optional.of(clazz.cast(this.policies()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<PolicySummary> policies;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesResponse model) {
            this.policies(model.policies);
            this.nextToken(model.nextToken);
        }

        public final Collection<PolicySummary.Builder> getPolicies() {
            return this.policies != null ? (Collection)this.policies.stream().map(PolicySummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policies(Collection<PolicySummary> policies) {
            this.policies = PoliciesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicySummary ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        public final void setPolicies(Collection<PolicySummary.BuilderImpl> policies) {
            this.policies = PoliciesCopier.copyFromBuilder(policies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPoliciesResponse build() {
            return new ListPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    CopyableBuilder<Builder, ListPoliciesResponse> {
        public Builder policies(Collection<PolicySummary> var1);

        public Builder policies(PolicySummary ... var1);

        public Builder nextToken(String var1);
    }
}

