/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.organizations.model.Child;
import software.amazon.awssdk.services.organizations.model.ChildrenCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListChildrenResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListChildrenResponse> {
    private final List<Child> children;
    private final String nextToken;

    private ListChildrenResponse(BuilderImpl builder) {
        super(builder);
        this.children = builder.children;
        this.nextToken = builder.nextToken;
    }

    public List<Child> children() {
        return this.children;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.children());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChildrenResponse)) {
            return false;
        }
        ListChildrenResponse other = (ListChildrenResponse)((Object)obj);
        return Objects.equals(this.children(), other.children()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListChildrenResponse").add("Children", this.children()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Children": {
                return Optional.of(clazz.cast(this.children()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<Child> children;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChildrenResponse model) {
            this.children(model.children);
            this.nextToken(model.nextToken);
        }

        public final Collection<Child.Builder> getChildren() {
            return this.children != null ? (Collection)this.children.stream().map(Child::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder children(Collection<Child> children) {
            this.children = ChildrenCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Child ... children) {
            this.children(Arrays.asList(children));
            return this;
        }

        public final void setChildren(Collection<Child.BuilderImpl> children) {
            this.children = ChildrenCopier.copyFromBuilder(children);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListChildrenResponse build() {
            return new ListChildrenResponse(this);
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    CopyableBuilder<Builder, ListChildrenResponse> {
        public Builder children(Collection<Child> var1);

        public Builder children(Child ... var1);

        public Builder nextToken(String var1);
    }
}

