/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal;
import software.amazon.awssdk.services.organizations.model.EnabledServicePrincipalsCopier;
import software.amazon.awssdk.services.organizations.model.OrganizationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAWSServiceAccessForOrganizationResponse
extends OrganizationsResponse
implements ToCopyableBuilder<Builder, ListAWSServiceAccessForOrganizationResponse> {
    private final List<EnabledServicePrincipal> enabledServicePrincipals;
    private final String nextToken;

    private ListAWSServiceAccessForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.enabledServicePrincipals = builder.enabledServicePrincipals;
        this.nextToken = builder.nextToken;
    }

    public List<EnabledServicePrincipal> enabledServicePrincipals() {
        return this.enabledServicePrincipals;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledServicePrincipals());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAWSServiceAccessForOrganizationResponse)) {
            return false;
        }
        ListAWSServiceAccessForOrganizationResponse other = (ListAWSServiceAccessForOrganizationResponse)((Object)obj);
        return Objects.equals(this.enabledServicePrincipals(), other.enabledServicePrincipals()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAWSServiceAccessForOrganizationResponse").add("EnabledServicePrincipals", this.enabledServicePrincipals()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnabledServicePrincipals": {
                return Optional.of(clazz.cast(this.enabledServicePrincipals()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsResponse.BuilderImpl
    implements Builder {
        private List<EnabledServicePrincipal> enabledServicePrincipals;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAWSServiceAccessForOrganizationResponse model) {
            this.enabledServicePrincipals(model.enabledServicePrincipals);
            this.nextToken(model.nextToken);
        }

        public final Collection<EnabledServicePrincipal.Builder> getEnabledServicePrincipals() {
            return this.enabledServicePrincipals != null ? (Collection)this.enabledServicePrincipals.stream().map(EnabledServicePrincipal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enabledServicePrincipals(Collection<EnabledServicePrincipal> enabledServicePrincipals) {
            this.enabledServicePrincipals = EnabledServicePrincipalsCopier.copy(enabledServicePrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledServicePrincipals(EnabledServicePrincipal ... enabledServicePrincipals) {
            this.enabledServicePrincipals(Arrays.asList(enabledServicePrincipals));
            return this;
        }

        public final void setEnabledServicePrincipals(Collection<EnabledServicePrincipal.BuilderImpl> enabledServicePrincipals) {
            this.enabledServicePrincipals = EnabledServicePrincipalsCopier.copyFromBuilder(enabledServicePrincipals);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAWSServiceAccessForOrganizationResponse build() {
            return new ListAWSServiceAccessForOrganizationResponse(this);
        }
    }

    public static interface Builder
    extends OrganizationsResponse.Builder,
    CopyableBuilder<Builder, ListAWSServiceAccessForOrganizationResponse> {
        public Builder enabledServicePrincipals(Collection<EnabledServicePrincipal> var1);

        public Builder enabledServicePrincipals(EnabledServicePrincipal ... var1);

        public Builder nextToken(String var1);
    }
}

