/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.HandshakePartyType;
import software.amazon.awssdk.services.organizations.transform.HandshakePartyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HandshakeParty
implements StructuredPojo,
ToCopyableBuilder<Builder, HandshakeParty> {
    private final String id;
    private final String type;

    private HandshakeParty(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
    }

    public String id() {
        return this.id;
    }

    public HandshakePartyType type() {
        return HandshakePartyType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandshakeParty)) {
            return false;
        }
        HandshakeParty other = (HandshakeParty)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeString(), other.typeString());
    }

    public String toString() {
        return ToString.builder((String)"HandshakeParty").add("Id", (Object)this.id()).add("Type", (Object)this.typeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HandshakePartyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(HandshakeParty model) {
            this.id(model.id);
            this.type(model.type);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HandshakePartyType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public HandshakeParty build() {
            return new HandshakeParty(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HandshakeParty> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(HandshakePartyType var1);
    }
}

