/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.organizations.model.OrganizationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetachPolicyRequest
extends OrganizationsRequest
implements ToCopyableBuilder<Builder, DetachPolicyRequest> {
    private final String policyId;
    private final String targetId;

    private DetachPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyId = builder.policyId;
        this.targetId = builder.targetId;
    }

    public String policyId() {
        return this.policyId;
    }

    public String targetId() {
        return this.targetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachPolicyRequest)) {
            return false;
        }
        DetachPolicyRequest other = (DetachPolicyRequest)((Object)obj);
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.targetId(), other.targetId());
    }

    public String toString() {
        return ToString.builder((String)"DetachPolicyRequest").add("PolicyId", (Object)this.policyId()).add("TargetId", (Object)this.targetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.of(clazz.cast(this.policyId()));
            }
            case "TargetId": {
                return Optional.of(clazz.cast(this.targetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OrganizationsRequest.BuilderImpl
    implements Builder {
        private String policyId;
        private String targetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachPolicyRequest model) {
            this.policyId(model.policyId);
            this.targetId(model.targetId);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DetachPolicyRequest build() {
            return new DetachPolicyRequest(this);
        }
    }

    public static interface Builder
    extends OrganizationsRequest.Builder,
    CopyableBuilder<Builder, DetachPolicyRequest> {
        public Builder policyId(String var1);

        public Builder targetId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

