/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.organizations.model.CreateAccountState;
import software.amazon.awssdk.services.organizations.model.CreateAccountStatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCreateAccountStatusRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListCreateAccountStatusRequest> {
    private final List<String> states;
    private final String nextToken;
    private final Integer maxResults;

    private ListCreateAccountStatusRequest(BuilderImpl builder) {
        this.states = builder.states;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public List<String> states() {
        return this.states;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.states() == null ? 0 : this.states().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCreateAccountStatusRequest)) {
            return false;
        }
        ListCreateAccountStatusRequest other = (ListCreateAccountStatusRequest)((Object)obj);
        if (other.states() == null ^ this.states() == null) {
            return false;
        }
        if (other.states() != null && !other.states().equals(this.states())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.states() != null) {
            sb.append("States: ").append(this.states()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> states;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCreateAccountStatusRequest model) {
            this.setStates(model.states);
            this.setNextToken(model.nextToken);
            this.setMaxResults(model.maxResults);
        }

        public final Collection<String> getStates() {
            return this.states;
        }

        @Override
        public final Builder states(Collection<String> states) {
            this.states = CreateAccountStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(String ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(CreateAccountState ... states) {
            this.states(Arrays.asList(states).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = CreateAccountStatesCopier.copy(states);
        }

        @SafeVarargs
        public final void setStates(String ... states) {
            this.states(Arrays.asList(states));
        }

        @SafeVarargs
        public final void setStates(CreateAccountState ... states) {
            this.states(Arrays.asList(states).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public ListCreateAccountStatusRequest build() {
            return new ListCreateAccountStatusRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCreateAccountStatusRequest> {
        public Builder states(Collection<String> var1);

        public Builder states(String ... var1);

        public Builder states(CreateAccountState ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

