/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.organizations.model.AccountJoinedMethod;
import software.amazon.awssdk.services.organizations.model.AccountStatus;
import software.amazon.awssdk.services.organizations.transform.AccountMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Account
implements StructuredPojo,
ToCopyableBuilder<Builder, Account> {
    private final String id;
    private final String arn;
    private final String email;
    private final String name;
    private final String status;
    private final String joinedMethod;
    private final Instant joinedTimestamp;

    private Account(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.email = builder.email;
        this.name = builder.name;
        this.status = builder.status;
        this.joinedMethod = builder.joinedMethod;
        this.joinedTimestamp = builder.joinedTimestamp;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String email() {
        return this.email;
    }

    public String name() {
        return this.name;
    }

    public String status() {
        return this.status;
    }

    public String joinedMethod() {
        return this.joinedMethod;
    }

    public Instant joinedTimestamp() {
        return this.joinedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.email() == null ? 0 : this.email().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.joinedMethod() == null ? 0 : this.joinedMethod().hashCode());
        hashCode = 31 * hashCode + (this.joinedTimestamp() == null ? 0 : this.joinedTimestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.email() == null ^ this.email() == null) {
            return false;
        }
        if (other.email() != null && !other.email().equals(this.email())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.joinedMethod() == null ^ this.joinedMethod() == null) {
            return false;
        }
        if (other.joinedMethod() != null && !other.joinedMethod().equals(this.joinedMethod())) {
            return false;
        }
        if (other.joinedTimestamp() == null ^ this.joinedTimestamp() == null) {
            return false;
        }
        return other.joinedTimestamp() == null || other.joinedTimestamp().equals(this.joinedTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.email() != null) {
            sb.append("Email: ").append(this.email()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.joinedMethod() != null) {
            sb.append("JoinedMethod: ").append(this.joinedMethod()).append(",");
        }
        if (this.joinedTimestamp() != null) {
            sb.append("JoinedTimestamp: ").append(this.joinedTimestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String email;
        private String name;
        private String status;
        private String joinedMethod;
        private Instant joinedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Account model) {
            this.setId(model.id);
            this.setArn(model.arn);
            this.setEmail(model.email);
            this.setName(model.name);
            this.setStatus(model.status);
            this.setJoinedMethod(model.joinedMethod);
            this.setJoinedTimestamp(model.joinedTimestamp);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccountStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(AccountStatus status) {
            this.status(status.toString());
        }

        public final String getJoinedMethod() {
            return this.joinedMethod;
        }

        @Override
        public final Builder joinedMethod(String joinedMethod) {
            this.joinedMethod = joinedMethod;
            return this;
        }

        @Override
        public final Builder joinedMethod(AccountJoinedMethod joinedMethod) {
            this.joinedMethod(joinedMethod.toString());
            return this;
        }

        public final void setJoinedMethod(String joinedMethod) {
            this.joinedMethod = joinedMethod;
        }

        public final void setJoinedMethod(AccountJoinedMethod joinedMethod) {
            this.joinedMethod(joinedMethod.toString());
        }

        public final Instant getJoinedTimestamp() {
            return this.joinedTimestamp;
        }

        @Override
        public final Builder joinedTimestamp(Instant joinedTimestamp) {
            this.joinedTimestamp = joinedTimestamp;
            return this;
        }

        public final void setJoinedTimestamp(Instant joinedTimestamp) {
            this.joinedTimestamp = joinedTimestamp;
        }

        public Account build() {
            return new Account(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Account> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder email(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(AccountStatus var1);

        public Builder joinedMethod(String var1);

        public Builder joinedMethod(AccountJoinedMethod var1);

        public Builder joinedTimestamp(Instant var1);
    }
}

