/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.NodeAssociationStatus;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNodeAssociationStatusResponse
extends OpsWorksCmResponse
implements ToCopyableBuilder<Builder, DescribeNodeAssociationStatusResponse> {
    private static final SdkField<String> NODE_ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeNodeAssociationStatusResponse.getter(DescribeNodeAssociationStatusResponse::nodeAssociationStatusAsString)).setter(DescribeNodeAssociationStatusResponse.setter(Builder::nodeAssociationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeAssociationStatus").build()}).build();
    private static final SdkField<List<EngineAttribute>> ENGINE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeNodeAssociationStatusResponse.getter(DescribeNodeAssociationStatusResponse::engineAttributes)).setter(DescribeNodeAssociationStatusResponse.setter(Builder::engineAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngineAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ASSOCIATION_STATUS_FIELD, ENGINE_ATTRIBUTES_FIELD));
    private final String nodeAssociationStatus;
    private final List<EngineAttribute> engineAttributes;

    private DescribeNodeAssociationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.nodeAssociationStatus = builder.nodeAssociationStatus;
        this.engineAttributes = builder.engineAttributes;
    }

    public NodeAssociationStatus nodeAssociationStatus() {
        return NodeAssociationStatus.fromValue(this.nodeAssociationStatus);
    }

    public String nodeAssociationStatusAsString() {
        return this.nodeAssociationStatus;
    }

    public List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeAssociationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeAssociationStatusResponse)) {
            return false;
        }
        DescribeNodeAssociationStatusResponse other = (DescribeNodeAssociationStatusResponse)((Object)obj);
        return Objects.equals(this.nodeAssociationStatusAsString(), other.nodeAssociationStatusAsString()) && Objects.equals(this.engineAttributes(), other.engineAttributes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNodeAssociationStatusResponse").add("NodeAssociationStatus", (Object)this.nodeAssociationStatusAsString()).add("EngineAttributes", this.engineAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeAssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.nodeAssociationStatusAsString()));
            }
            case "EngineAttributes": {
                return Optional.ofNullable(clazz.cast(this.engineAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeAssociationStatusResponse, T> g) {
        return obj -> g.apply((DescribeNodeAssociationStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksCmResponse.BuilderImpl
    implements Builder {
        private String nodeAssociationStatus;
        private List<EngineAttribute> engineAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeAssociationStatusResponse model) {
            super(model);
            this.nodeAssociationStatus(model.nodeAssociationStatus);
            this.engineAttributes(model.engineAttributes);
        }

        public final String getNodeAssociationStatusAsString() {
            return this.nodeAssociationStatus;
        }

        @Override
        public final Builder nodeAssociationStatus(String nodeAssociationStatus) {
            this.nodeAssociationStatus = nodeAssociationStatus;
            return this;
        }

        @Override
        public final Builder nodeAssociationStatus(NodeAssociationStatus nodeAssociationStatus) {
            this.nodeAssociationStatus(nodeAssociationStatus == null ? null : nodeAssociationStatus.toString());
            return this;
        }

        public final void setNodeAssociationStatus(String nodeAssociationStatus) {
            this.nodeAssociationStatus = nodeAssociationStatus;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            return this.engineAttributes != null ? (Collection)this.engineAttributes.stream().map(EngineAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            this.engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder> ... engineAttributes) {
            this.engineAttributes(Stream.of(engineAttributes).map(c -> (EngineAttribute)((EngineAttribute.Builder)EngineAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        @Override
        public DescribeNodeAssociationStatusResponse build() {
            return new DescribeNodeAssociationStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksCmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNodeAssociationStatusResponse> {
        public Builder nodeAssociationStatus(String var1);

        public Builder nodeAssociationStatus(NodeAssociationStatus var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);

        public Builder engineAttributes(Consumer<EngineAttribute.Builder> ... var1);
    }
}

