/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmClient;
import software.amazon.awssdk.services.opsworkscm.internal.UserAgentUtils;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse;
import software.amazon.awssdk.services.opsworkscm.model.Server;

public class DescribeServersIterable
implements SdkIterable<DescribeServersResponse> {
    private final OpsWorksCmClient client;
    private final DescribeServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeServersIterable(OpsWorksCmClient client, DescribeServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeServersResponseFetcher();
    }

    public Iterator<DescribeServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Server> servers() {
        Function<DescribeServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.servers() != null) {
                return response.servers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeServersResponseFetcher
    implements SyncPageFetcher<DescribeServersResponse> {
        private DescribeServersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeServersResponse nextPage(DescribeServersResponse previousPage) {
            if (previousPage == null) {
                return DescribeServersIterable.this.client.describeServers(DescribeServersIterable.this.firstRequest);
            }
            return DescribeServersIterable.this.client.describeServers((DescribeServersRequest)((Object)DescribeServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

