/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opsworkscm.DefaultOpsWorksCmBaseClientBuilder;
import software.amazon.awssdk.services.opsworkscm.DefaultOpsWorksCmClient;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmClient;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmClientBuilder;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmServiceClientConfiguration;
import software.amazon.awssdk.services.opsworkscm.endpoints.OpsWorksCmEndpointProvider;

@SdkInternalApi
final class DefaultOpsWorksCmClientBuilder
extends DefaultOpsWorksCmBaseClientBuilder<OpsWorksCmClientBuilder, OpsWorksCmClient>
implements OpsWorksCmClientBuilder {
    DefaultOpsWorksCmClientBuilder() {
    }

    @Override
    public DefaultOpsWorksCmClientBuilder endpointProvider(OpsWorksCmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OpsWorksCmClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOpsWorksCmClientBuilder.validateClientOptions(clientConfiguration);
        OpsWorksCmServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOpsWorksCmClient client = new DefaultOpsWorksCmClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OpsWorksCmServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OpsWorksCmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

