/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opsworkscm.DefaultOpsWorksCmBaseClientBuilder;
import software.amazon.awssdk.services.opsworkscm.DefaultOpsWorksCmClient;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmClient;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmClientBuilder;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmServiceClientConfiguration;
import software.amazon.awssdk.services.opsworkscm.endpoints.OpsWorksCmEndpointProvider;

@SdkInternalApi
final class DefaultOpsWorksCmClientBuilder
extends DefaultOpsWorksCmBaseClientBuilder<OpsWorksCmClientBuilder, OpsWorksCmClient>
implements OpsWorksCmClientBuilder {
    DefaultOpsWorksCmClientBuilder() {
    }

    @Override
    public DefaultOpsWorksCmClientBuilder endpointProvider(OpsWorksCmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OpsWorksCmClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOpsWorksCmClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        OpsWorksCmServiceClientConfiguration serviceClientConfiguration = OpsWorksCmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultOpsWorksCmClient(serviceClientConfiguration, clientConfiguration);
    }
}

