/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opsworkscm.DefaultOpsWorksCmAsyncClient;
import software.amazon.awssdk.services.opsworkscm.DefaultOpsWorksCmBaseClientBuilder;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmAsyncClient;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmAsyncClientBuilder;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmServiceClientConfiguration;
import software.amazon.awssdk.services.opsworkscm.endpoints.OpsWorksCmEndpointProvider;

@SdkInternalApi
final class DefaultOpsWorksCmAsyncClientBuilder
extends DefaultOpsWorksCmBaseClientBuilder<OpsWorksCmAsyncClientBuilder, OpsWorksCmAsyncClient>
implements OpsWorksCmAsyncClientBuilder {
    DefaultOpsWorksCmAsyncClientBuilder() {
    }

    @Override
    public DefaultOpsWorksCmAsyncClientBuilder endpointProvider(OpsWorksCmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OpsWorksCmAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultOpsWorksCmAsyncClientBuilder.validateClientOptions(clientConfiguration);
        OpsWorksCmServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOpsWorksCmAsyncClient client = new DefaultOpsWorksCmAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OpsWorksCmServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OpsWorksCmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

