/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBackupsRequest
extends OpsWorksCmRequest
implements ToCopyableBuilder<Builder, DescribeBackupsRequest> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupId").getter(DescribeBackupsRequest.getter(DescribeBackupsRequest::backupId)).setter(DescribeBackupsRequest.setter(Builder::backupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(DescribeBackupsRequest.getter(DescribeBackupsRequest::serverName)).setter(DescribeBackupsRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeBackupsRequest.getter(DescribeBackupsRequest::nextToken)).setter(DescribeBackupsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeBackupsRequest.getter(DescribeBackupsRequest::maxResults)).setter(DescribeBackupsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD, SERVER_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String backupId;
    private final String serverName;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.serverName = builder.serverName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String backupId() {
        return this.backupId;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupsRequest)) {
            return false;
        }
        DescribeBackupsRequest other = (DescribeBackupsRequest)((Object)obj);
        return Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBackupsRequest").add("BackupId", (Object)this.backupId()).add("ServerName", (Object)this.serverName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupsRequest, T> g) {
        return obj -> g.apply((DescribeBackupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksCmRequest.BuilderImpl
    implements Builder {
        private String backupId;
        private String serverName;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupsRequest model) {
            super(model);
            this.backupId(model.backupId);
            this.serverName(model.serverName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        @Transient
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        @Transient
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBackupsRequest build() {
            return new DescribeBackupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksCmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBackupsRequest> {
        public Builder backupId(String var1);

        public Builder serverName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

