/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountAttribute> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AccountAttribute.getter(AccountAttribute::name)).setter(AccountAttribute.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Maximum").getter(AccountAttribute.getter(AccountAttribute::maximum)).setter(AccountAttribute.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()}).build();
    private static final SdkField<Integer> USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Used").getter(AccountAttribute.getter(AccountAttribute::used)).setter(AccountAttribute.setter(Builder::used)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Used").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAXIMUM_FIELD, USED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer maximum;
    private final Integer used;

    private AccountAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.maximum = builder.maximum;
        this.used = builder.used;
    }

    public final String name() {
        return this.name;
    }

    public final Integer maximum() {
        return this.maximum;
    }

    public final Integer used() {
        return this.used;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.used());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttribute)) {
            return false;
        }
        AccountAttribute other = (AccountAttribute)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.used(), other.used());
    }

    public final String toString() {
        return ToString.builder((String)"AccountAttribute").add("Name", (Object)this.name()).add("Maximum", (Object)this.maximum()).add("Used", (Object)this.used()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
            case "Used": {
                return Optional.ofNullable(clazz.cast(this.used()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountAttribute, T> g) {
        return obj -> g.apply((AccountAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer maximum;
        private Integer used;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAttribute model) {
            this.name(model.name);
            this.maximum(model.maximum);
            this.used(model.used);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        public final Integer getUsed() {
            return this.used;
        }

        @Override
        public final Builder used(Integer used) {
            this.used = used;
            return this;
        }

        public final void setUsed(Integer used) {
            this.used = used;
        }

        public AccountAttribute build() {
            return new AccountAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountAttribute> {
        public Builder name(String var1);

        public Builder maximum(Integer var1);

        public Builder used(Integer var1);
    }
}

