/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworkscm.model.BackupStatus;
import software.amazon.awssdk.services.opsworkscm.model.BackupType;
import software.amazon.awssdk.services.opsworkscm.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Backup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Backup> {
    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupArn").getter(Backup.getter(Backup::backupArn)).setter(Backup.setter(Builder::backupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()}).build();
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupId").getter(Backup.getter(Backup::backupId)).setter(Backup.setter(Builder::backupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()}).build();
    private static final SdkField<String> BACKUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupType").getter(Backup.getter(Backup::backupTypeAsString)).setter(Backup.setter(Builder::backupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Backup.getter(Backup::createdAt)).setter(Backup.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Backup.getter(Backup::description)).setter(Backup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(Backup.getter(Backup::engine)).setter(Backup.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineModel").getter(Backup.getter(Backup::engineModel)).setter(Backup.setter(Builder::engineModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineModel").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(Backup.getter(Backup::engineVersion)).setter(Backup.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileArn").getter(Backup.getter(Backup::instanceProfileArn)).setter(Backup.setter(Builder::instanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileArn").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(Backup.getter(Backup::instanceType)).setter(Backup.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPair").getter(Backup.getter(Backup::keyPair)).setter(Backup.setter(Builder::keyPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPair").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(Backup.getter(Backup::preferredBackupWindow)).setter(Backup.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(Backup.getter(Backup::preferredMaintenanceWindow)).setter(Backup.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Integer> S3_DATA_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("S3DataSize").getter(Backup.getter(Backup::s3DataSize)).setter(Backup.setter(Builder::s3DataSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataSize").build()}).build();
    private static final SdkField<String> S3_DATA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3DataUrl").getter(Backup.getter(Backup::s3DataUrl)).setter(Backup.setter(Builder::s3DataUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataUrl").build()}).build();
    private static final SdkField<String> S3_LOG_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3LogUrl").getter(Backup.getter(Backup::s3LogUrl)).setter(Backup.setter(Builder::s3LogUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3LogUrl").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(Backup.getter(Backup::securityGroupIds)).setter(Backup.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(Backup.getter(Backup::serverName)).setter(Backup.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRoleArn").getter(Backup.getter(Backup::serviceRoleArn)).setter(Backup.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Backup.getter(Backup::statusAsString)).setter(Backup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDescription").getter(Backup.getter(Backup::statusDescription)).setter(Backup.setter(Builder::statusDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDescription").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(Backup.getter(Backup::subnetIds)).setter(Backup.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TOOLS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ToolsVersion").getter(Backup.getter(Backup::toolsVersion)).setter(Backup.setter(Builder::toolsVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToolsVersion").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserArn").getter(Backup.getter(Backup::userArn)).setter(Backup.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ARN_FIELD, BACKUP_ID_FIELD, BACKUP_TYPE_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, ENGINE_MODEL_FIELD, ENGINE_VERSION_FIELD, INSTANCE_PROFILE_ARN_FIELD, INSTANCE_TYPE_FIELD, KEY_PAIR_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, S3_DATA_SIZE_FIELD, S3_DATA_URL_FIELD, S3_LOG_URL_FIELD, SECURITY_GROUP_IDS_FIELD, SERVER_NAME_FIELD, SERVICE_ROLE_ARN_FIELD, STATUS_FIELD, STATUS_DESCRIPTION_FIELD, SUBNET_IDS_FIELD, TOOLS_VERSION_FIELD, USER_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backupArn;
    private final String backupId;
    private final String backupType;
    private final Instant createdAt;
    private final String description;
    private final String engine;
    private final String engineModel;
    private final String engineVersion;
    private final String instanceProfileArn;
    private final String instanceType;
    private final String keyPair;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final Integer s3DataSize;
    private final String s3DataUrl;
    private final String s3LogUrl;
    private final List<String> securityGroupIds;
    private final String serverName;
    private final String serviceRoleArn;
    private final String status;
    private final String statusDescription;
    private final List<String> subnetIds;
    private final String toolsVersion;
    private final String userArn;

    private Backup(BuilderImpl builder) {
        this.backupArn = builder.backupArn;
        this.backupId = builder.backupId;
        this.backupType = builder.backupType;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineVersion = builder.engineVersion;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.s3DataSize = builder.s3DataSize;
        this.s3DataUrl = builder.s3DataUrl;
        this.s3LogUrl = builder.s3LogUrl;
        this.securityGroupIds = builder.securityGroupIds;
        this.serverName = builder.serverName;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.status = builder.status;
        this.statusDescription = builder.statusDescription;
        this.subnetIds = builder.subnetIds;
        this.toolsVersion = builder.toolsVersion;
        this.userArn = builder.userArn;
    }

    public String backupArn() {
        return this.backupArn;
    }

    public String backupId() {
        return this.backupId;
    }

    public BackupType backupType() {
        return BackupType.fromValue(this.backupType);
    }

    public String backupTypeAsString() {
        return this.backupType;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String description() {
        return this.description;
    }

    public String engine() {
        return this.engine;
    }

    public String engineModel() {
        return this.engineModel;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String keyPair() {
        return this.keyPair;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Integer s3DataSize() {
        return this.s3DataSize;
    }

    public String s3DataUrl() {
        return this.s3DataUrl;
    }

    public String s3LogUrl() {
        return this.s3LogUrl;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String serverName() {
        return this.serverName;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public BackupStatus status() {
        return BackupStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusDescription() {
        return this.statusDescription;
    }

    public boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String toolsVersion() {
        return this.toolsVersion;
    }

    public String userArn() {
        return this.userArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3LogUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.toolsVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backup)) {
            return false;
        }
        Backup other = (Backup)obj;
        return Objects.equals(this.backupArn(), other.backupArn()) && Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.backupTypeAsString(), other.backupTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineModel(), other.engineModel()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.instanceProfileArn(), other.instanceProfileArn()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.keyPair(), other.keyPair()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.s3DataSize(), other.s3DataSize()) && Objects.equals(this.s3DataUrl(), other.s3DataUrl()) && Objects.equals(this.s3LogUrl(), other.s3LogUrl()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDescription(), other.statusDescription()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.toolsVersion(), other.toolsVersion()) && Objects.equals(this.userArn(), other.userArn());
    }

    public String toString() {
        return ToString.builder((String)"Backup").add("BackupArn", (Object)this.backupArn()).add("BackupId", (Object)this.backupId()).add("BackupType", (Object)this.backupTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("Engine", (Object)this.engine()).add("EngineModel", (Object)this.engineModel()).add("EngineVersion", (Object)this.engineVersion()).add("InstanceProfileArn", (Object)this.instanceProfileArn()).add("InstanceType", (Object)this.instanceType()).add("KeyPair", (Object)this.keyPair()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("S3DataSize", (Object)this.s3DataSize()).add("S3DataUrl", (Object)this.s3DataUrl()).add("S3LogUrl", (Object)this.s3LogUrl()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("ServerName", (Object)this.serverName()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("Status", (Object)this.statusAsString()).add("StatusDescription", (Object)this.statusDescription()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("ToolsVersion", (Object)this.toolsVersion()).add("UserArn", (Object)this.userArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupArn": {
                return Optional.ofNullable(clazz.cast(this.backupArn()));
            }
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
            case "BackupType": {
                return Optional.ofNullable(clazz.cast(this.backupTypeAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineModel": {
                return Optional.ofNullable(clazz.cast(this.engineModel()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "InstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileArn()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KeyPair": {
                return Optional.ofNullable(clazz.cast(this.keyPair()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "S3DataSize": {
                return Optional.ofNullable(clazz.cast(this.s3DataSize()));
            }
            case "S3DataUrl": {
                return Optional.ofNullable(clazz.cast(this.s3DataUrl()));
            }
            case "S3LogUrl": {
                return Optional.ofNullable(clazz.cast(this.s3LogUrl()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDescription": {
                return Optional.ofNullable(clazz.cast(this.statusDescription()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "ToolsVersion": {
                return Optional.ofNullable(clazz.cast(this.toolsVersion()));
            }
            case "UserArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Backup, T> g) {
        return obj -> g.apply((Backup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupArn;
        private String backupId;
        private String backupType;
        private Instant createdAt;
        private String description;
        private String engine;
        private String engineModel;
        private String engineVersion;
        private String instanceProfileArn;
        private String instanceType;
        private String keyPair;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private Integer s3DataSize;
        private String s3DataUrl;
        private String s3LogUrl;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String serverName;
        private String serviceRoleArn;
        private String status;
        private String statusDescription;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String toolsVersion;
        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Backup model) {
            this.backupArn(model.backupArn);
            this.backupId(model.backupId);
            this.backupType(model.backupType);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.engine(model.engine);
            this.engineModel(model.engineModel);
            this.engineVersion(model.engineVersion);
            this.instanceProfileArn(model.instanceProfileArn);
            this.instanceType(model.instanceType);
            this.keyPair(model.keyPair);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.s3DataSize(model.s3DataSize);
            this.s3DataUrl(model.s3DataUrl);
            this.s3LogUrl(model.s3LogUrl);
            this.securityGroupIds(model.securityGroupIds);
            this.serverName(model.serverName);
            this.serviceRoleArn(model.serviceRoleArn);
            this.status(model.status);
            this.statusDescription(model.statusDescription);
            this.subnetIds(model.subnetIds);
            this.toolsVersion(model.toolsVersion);
            this.userArn(model.userArn);
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getBackupType() {
            return this.backupType;
        }

        @Override
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public final Builder backupType(BackupType backupType) {
            this.backupType(backupType == null ? null : backupType.toString());
            return this;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineModel() {
            return this.engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getS3DataSize() {
            return this.s3DataSize;
        }

        @Override
        public final Builder s3DataSize(Integer s3DataSize) {
            this.s3DataSize = s3DataSize;
            return this;
        }

        public final void setS3DataSize(Integer s3DataSize) {
            this.s3DataSize = s3DataSize;
        }

        public final String getS3DataUrl() {
            return this.s3DataUrl;
        }

        @Override
        public final Builder s3DataUrl(String s3DataUrl) {
            this.s3DataUrl = s3DataUrl;
            return this;
        }

        public final void setS3DataUrl(String s3DataUrl) {
            this.s3DataUrl = s3DataUrl;
        }

        public final String getS3LogUrl() {
            return this.s3LogUrl;
        }

        @Override
        public final Builder s3LogUrl(String s3LogUrl) {
            this.s3LogUrl = s3LogUrl;
            return this;
        }

        public final void setS3LogUrl(String s3LogUrl) {
            this.s3LogUrl = s3LogUrl;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BackupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDescription() {
            return this.statusDescription;
        }

        @Override
        public final Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        public final void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final String getToolsVersion() {
            return this.toolsVersion;
        }

        @Override
        public final Builder toolsVersion(String toolsVersion) {
            this.toolsVersion = toolsVersion;
            return this;
        }

        public final void setToolsVersion(String toolsVersion) {
            this.toolsVersion = toolsVersion;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public Backup build() {
            return new Backup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Backup> {
        public Builder backupArn(String var1);

        public Builder backupId(String var1);

        public Builder backupType(String var1);

        public Builder backupType(BackupType var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder engine(String var1);

        public Builder engineModel(String var1);

        public Builder engineVersion(String var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder s3DataSize(Integer var1);

        public Builder s3DataUrl(String var1);

        public Builder s3LogUrl(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder serverName(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder status(String var1);

        public Builder status(BackupStatus var1);

        public Builder statusDescription(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder toolsVersion(String var1);

        public Builder userArn(String var1);
    }
}

