/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ServerStatus {
    BACKING_UP("BACKING_UP"),
    CONNECTION_LOST("CONNECTION_LOST"),
    CREATING("CREATING"),
    DELETING("DELETING"),
    MODIFYING("MODIFYING"),
    FAILED("FAILED"),
    HEALTHY("HEALTHY"),
    RUNNING("RUNNING"),
    RESTORING("RESTORING"),
    SETUP("SETUP"),
    UNDER_MAINTENANCE("UNDER_MAINTENANCE"),
    UNHEALTHY("UNHEALTHY"),
    TERMINATED("TERMINATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ServerStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ServerStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerStatus> knownValues() {
        return Stream.of(ServerStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

