/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerEvent> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ServerEvent.getter(ServerEvent::createdAt)).setter(ServerEvent.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServerEvent.getter(ServerEvent::serverName)).setter(ServerEvent.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServerEvent.getter(ServerEvent::message)).setter(ServerEvent.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> LOG_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServerEvent.getter(ServerEvent::logUrl)).setter(ServerEvent.setter(Builder::logUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, SERVER_NAME_FIELD, MESSAGE_FIELD, LOG_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String serverName;
    private final String message;
    private final String logUrl;

    private ServerEvent(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.serverName = builder.serverName;
        this.message = builder.message;
        this.logUrl = builder.logUrl;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String serverName() {
        return this.serverName;
    }

    public String message() {
        return this.message;
    }

    public String logUrl() {
        return this.logUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerEvent)) {
            return false;
        }
        ServerEvent other = (ServerEvent)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.logUrl(), other.logUrl());
    }

    public String toString() {
        return ToString.builder((String)"ServerEvent").add("CreatedAt", (Object)this.createdAt()).add("ServerName", (Object)this.serverName()).add("Message", (Object)this.message()).add("LogUrl", (Object)this.logUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "LogUrl": {
                return Optional.ofNullable(clazz.cast(this.logUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerEvent, T> g) {
        return obj -> g.apply((ServerEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String serverName;
        private String message;
        private String logUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerEvent model) {
            this.createdAt(model.createdAt);
            this.serverName(model.serverName);
            this.message(model.message);
            this.logUrl(model.logUrl);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getLogUrl() {
            return this.logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        public ServerEvent build() {
            return new ServerEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerEvent> {
        public Builder createdAt(Instant var1);

        public Builder serverName(String var1);

        public Builder message(String var1);

        public Builder logUrl(String var1);
    }
}

