/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmClient;
import software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest;
import software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse;
import software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest;
import software.amazon.awssdk.services.opsworkscm.model.CreateBackupResponse;
import software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.CreateServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest;
import software.amazon.awssdk.services.opsworkscm.model.DeleteBackupResponse;
import software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.DeleteServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse;
import software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest;
import software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeResponse;
import software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeRequest;
import software.amazon.awssdk.services.opsworkscm.model.ExportServerEngineAttributeResponse;
import software.amazon.awssdk.services.opsworkscm.model.InvalidNextTokenException;
import software.amazon.awssdk.services.opsworkscm.model.InvalidStateException;
import software.amazon.awssdk.services.opsworkscm.model.LimitExceededException;
import software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.opsworkscm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmException;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmRequest;
import software.amazon.awssdk.services.opsworkscm.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.opsworkscm.model.ResourceNotFoundException;
import software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.RestoreServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest;
import software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceResponse;
import software.amazon.awssdk.services.opsworkscm.model.TagResourceRequest;
import software.amazon.awssdk.services.opsworkscm.model.TagResourceResponse;
import software.amazon.awssdk.services.opsworkscm.model.UntagResourceRequest;
import software.amazon.awssdk.services.opsworkscm.model.UntagResourceResponse;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesResponse;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.ValidationException;
import software.amazon.awssdk.services.opsworkscm.paginators.DescribeBackupsIterable;
import software.amazon.awssdk.services.opsworkscm.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.opsworkscm.paginators.DescribeServersIterable;
import software.amazon.awssdk.services.opsworkscm.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.opsworkscm.transform.AssociateNodeRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeBackupsRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeNodeAssociationStatusRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeServersRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DisassociateNodeRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.ExportServerEngineAttributeRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.RestoreServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.StartMaintenanceRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerEngineAttributesRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerRequestMarshaller;

@SdkInternalApi
final class DefaultOpsWorksCmClient
implements OpsWorksCmClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOpsWorksCmClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "opsworks-cm";
    }

    @Override
    public AssociateNodeResponse associateNode(AssociateNodeRequest associateNodeRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateNodeRequest).withMarshaller((Marshaller)new AssociateNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest createBackupRequest) throws InvalidStateException, LimitExceededException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBackupRequest).withMarshaller((Marshaller)new CreateBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateServerResponse createServer(CreateServerRequest createServerRequest) throws LimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createServerRequest).withMarshaller((Marshaller)new CreateServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBackupRequest).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteServerResponse deleteServer(DeleteServerRequest deleteServerRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServerRequest).withMarshaller((Marshaller)new DeleteServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAccountAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountAttributesRequest).withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeBackupsResponse describeBackups(DescribeBackupsRequest describeBackupsRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBackupsRequest).withMarshaller((Marshaller)new DescribeBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeBackupsIterable describeBackupsPaginator(DescribeBackupsRequest describeBackupsRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, OpsWorksCmException {
        return new DescribeBackupsIterable(this, this.applyPaginatorUserAgent(describeBackupsRequest));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws ValidationException, InvalidNextTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws ValidationException, InvalidNextTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, OpsWorksCmException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public DescribeNodeAssociationStatusResponse describeNodeAssociationStatus(DescribeNodeAssociationStatusRequest describeNodeAssociationStatusRequest) throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNodeAssociationStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeNodeAssociationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNodeAssociationStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNodeAssociationStatusRequest).withMarshaller((Marshaller)new DescribeNodeAssociationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeServersResponse describeServers(DescribeServersRequest describeServersRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServersRequest).withMarshaller((Marshaller)new DescribeServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeServersIterable describeServersPaginator(DescribeServersRequest describeServersRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, OpsWorksCmException {
        return new DescribeServersIterable(this, this.applyPaginatorUserAgent(describeServersRequest));
    }

    @Override
    public DisassociateNodeResponse disassociateNode(DisassociateNodeRequest disassociateNodeRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateNodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateNode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateNodeRequest).withMarshaller((Marshaller)new DisassociateNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ExportServerEngineAttributeResponse exportServerEngineAttribute(ExportServerEngineAttributeRequest exportServerEngineAttributeRequest) throws ValidationException, ResourceNotFoundException, InvalidStateException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportServerEngineAttributeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ExportServerEngineAttributeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportServerEngineAttribute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportServerEngineAttributeRequest).withMarshaller((Marshaller)new ExportServerEngineAttributeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    @Override
    public RestoreServerResponse restoreServer(RestoreServerRequest restoreServerRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RestoreServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreServerRequest).withMarshaller((Marshaller)new RestoreServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartMaintenanceResponse startMaintenance(StartMaintenanceRequest startMaintenanceRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMaintenanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartMaintenanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMaintenance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startMaintenanceRequest).withMarshaller((Marshaller)new StartMaintenanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ValidationException, InvalidStateException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ValidationException, InvalidStateException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateServerResponse updateServer(UpdateServerRequest updateServerRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServerRequest).withMarshaller((Marshaller)new UpdateServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateServerEngineAttributesResponse updateServerEngineAttributes(UpdateServerEngineAttributesRequest updateServerEngineAttributesRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OpsWorksCmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServerEngineAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateServerEngineAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServerEngineAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServerEngineAttributesRequest).withMarshaller((Marshaller)new UpdateServerEngineAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(OpsWorksCmException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateException").exceptionBuilderSupplier(InvalidStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends OpsWorksCmRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.26").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((OpsWorksCmRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

