/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateNodeRequest
extends OpsWorksCmRequest
implements ToCopyableBuilder<Builder, AssociateNodeRequest> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociateNodeRequest.getter(AssociateNodeRequest::serverName)).setter(AssociateNodeRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociateNodeRequest.getter(AssociateNodeRequest::nodeName)).setter(AssociateNodeRequest.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeName").build()}).build();
    private static final SdkField<List<EngineAttribute>> ENGINE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AssociateNodeRequest.getter(AssociateNodeRequest::engineAttributes)).setter(AssociateNodeRequest.setter(Builder::engineAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngineAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, NODE_NAME_FIELD, ENGINE_ATTRIBUTES_FIELD));
    private final String serverName;
    private final String nodeName;
    private final List<EngineAttribute> engineAttributes;

    private AssociateNodeRequest(BuilderImpl builder) {
        super(builder);
        this.serverName = builder.serverName;
        this.nodeName = builder.nodeName;
        this.engineAttributes = builder.engineAttributes;
    }

    public String serverName() {
        return this.serverName;
    }

    public String nodeName() {
        return this.nodeName;
    }

    public List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateNodeRequest)) {
            return false;
        }
        AssociateNodeRequest other = (AssociateNodeRequest)((Object)obj);
        return Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.engineAttributes(), other.engineAttributes());
    }

    public String toString() {
        return ToString.builder((String)"AssociateNodeRequest").add("ServerName", (Object)this.serverName()).add("NodeName", (Object)this.nodeName()).add("EngineAttributes", this.engineAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "NodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "EngineAttributes": {
                return Optional.ofNullable(clazz.cast(this.engineAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateNodeRequest, T> g) {
        return obj -> g.apply((AssociateNodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksCmRequest.BuilderImpl
    implements Builder {
        private String serverName;
        private String nodeName;
        private List<EngineAttribute> engineAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateNodeRequest model) {
            super(model);
            this.serverName(model.serverName);
            this.nodeName(model.nodeName);
            this.engineAttributes(model.engineAttributes);
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            return this.engineAttributes != null ? (Collection)this.engineAttributes.stream().map(EngineAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            this.engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder> ... engineAttributes) {
            this.engineAttributes(Stream.of(engineAttributes).map(c -> (EngineAttribute)((EngineAttribute.Builder)EngineAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateNodeRequest build() {
            return new AssociateNodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksCmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateNodeRequest> {
        public Builder serverName(String var1);

        public Builder nodeName(String var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);

        public Builder engineAttributes(Consumer<EngineAttribute.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

