/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreServerRequest
extends OpsWorksCMRequest
implements ToCopyableBuilder<Builder, RestoreServerRequest> {
    private final String backupId;
    private final String serverName;
    private final String instanceType;
    private final String keyPair;

    private RestoreServerRequest(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.serverName = builder.serverName;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
    }

    public String backupId() {
        return this.backupId;
    }

    public String serverName() {
        return this.serverName;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String keyPair() {
        return this.keyPair;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreServerRequest)) {
            return false;
        }
        RestoreServerRequest other = (RestoreServerRequest)((Object)obj);
        return Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.keyPair(), other.keyPair());
    }

    public String toString() {
        return ToString.builder((String)"RestoreServerRequest").add("BackupId", (Object)this.backupId()).add("ServerName", (Object)this.serverName()).add("InstanceType", (Object)this.instanceType()).add("KeyPair", (Object)this.keyPair()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.of(clazz.cast(this.backupId()));
            }
            case "ServerName": {
                return Optional.of(clazz.cast(this.serverName()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "KeyPair": {
                return Optional.of(clazz.cast(this.keyPair()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksCMRequest.BuilderImpl
    implements Builder {
        private String backupId;
        private String serverName;
        private String instanceType;
        private String keyPair;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreServerRequest model) {
            this.backupId(model.backupId);
            this.serverName(model.serverName);
            this.instanceType(model.instanceType);
            this.keyPair(model.keyPair);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RestoreServerRequest build() {
            return new RestoreServerRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksCMRequest.Builder,
    CopyableBuilder<Builder, RestoreServerRequest> {
        public Builder backupId(String var1);

        public Builder serverName(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

