/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartMaintenanceRequest
extends OpsWorksCMRequest
implements ToCopyableBuilder<Builder, StartMaintenanceRequest> {
    private final String serverName;
    private final List<EngineAttribute> engineAttributes;

    private StartMaintenanceRequest(BuilderImpl builder) {
        super(builder);
        this.serverName = builder.serverName;
        this.engineAttributes = builder.engineAttributes;
    }

    public String serverName() {
        return this.serverName;
    }

    public List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMaintenanceRequest)) {
            return false;
        }
        StartMaintenanceRequest other = (StartMaintenanceRequest)((Object)obj);
        return Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.engineAttributes(), other.engineAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.engineAttributes() != null) {
            sb.append("EngineAttributes: ").append(this.engineAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.of(clazz.cast(this.serverName()));
            }
            case "EngineAttributes": {
                return Optional.of(clazz.cast(this.engineAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksCMRequest.BuilderImpl
    implements Builder {
        private String serverName;
        private List<EngineAttribute> engineAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMaintenanceRequest model) {
            this.serverName(model.serverName);
            this.engineAttributes(model.engineAttributes);
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            return this.engineAttributes != null ? (Collection)this.engineAttributes.stream().map(EngineAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            this.engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartMaintenanceRequest build() {
            return new StartMaintenanceRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksCMRequest.Builder,
    CopyableBuilder<Builder, StartMaintenanceRequest> {
        public Builder serverName(String var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

