/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteBackupRequest
extends OpsWorksCMRequest
implements ToCopyableBuilder<Builder, DeleteBackupRequest> {
    private final String backupId;

    private DeleteBackupRequest(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
    }

    public String backupId() {
        return this.backupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBackupRequest)) {
            return false;
        }
        DeleteBackupRequest other = (DeleteBackupRequest)((Object)obj);
        return Objects.equals(this.backupId(), other.backupId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.backupId() != null) {
            sb.append("BackupId: ").append(this.backupId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.of(clazz.cast(this.backupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksCMRequest.BuilderImpl
    implements Builder {
        private String backupId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBackupRequest model) {
            this.backupId(model.backupId);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteBackupRequest build() {
            return new DeleteBackupRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksCMRequest.Builder,
    CopyableBuilder<Builder, DeleteBackupRequest> {
        public Builder backupId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

