/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMRequest;
import software.amazon.awssdk.services.opsworkscm.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateServerRequest
extends OpsWorksCMRequest
implements ToCopyableBuilder<Builder, CreateServerRequest> {
    private final Boolean associatePublicIpAddress;
    private final Boolean disableAutomatedBackup;
    private final String engine;
    private final String engineModel;
    private final String engineVersion;
    private final List<EngineAttribute> engineAttributes;
    private final Integer backupRetentionCount;
    private final String serverName;
    private final String instanceProfileArn;
    private final String instanceType;
    private final String keyPair;
    private final String preferredMaintenanceWindow;
    private final String preferredBackupWindow;
    private final List<String> securityGroupIds;
    private final String serviceRoleArn;
    private final List<String> subnetIds;
    private final String backupId;

    private CreateServerRequest(BuilderImpl builder) {
        super(builder);
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineVersion = builder.engineVersion;
        this.engineAttributes = builder.engineAttributes;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.subnetIds = builder.subnetIds;
        this.backupId = builder.backupId;
    }

    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public Boolean disableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    public String engine() {
        return this.engine;
    }

    public String engineModel() {
        return this.engineModel;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    public Integer backupRetentionCount() {
        return this.backupRetentionCount;
    }

    public String serverName() {
        return this.serverName;
    }

    public String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String keyPair() {
        return this.keyPair;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String backupId() {
        return this.backupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableAutomatedBackup());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerRequest)) {
            return false;
        }
        CreateServerRequest other = (CreateServerRequest)((Object)obj);
        return Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.disableAutomatedBackup(), other.disableAutomatedBackup()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineModel(), other.engineModel()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.engineAttributes(), other.engineAttributes()) && Objects.equals(this.backupRetentionCount(), other.backupRetentionCount()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.instanceProfileArn(), other.instanceProfileArn()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.keyPair(), other.keyPair()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.backupId(), other.backupId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(this.associatePublicIpAddress()).append(",");
        }
        if (this.disableAutomatedBackup() != null) {
            sb.append("DisableAutomatedBackup: ").append(this.disableAutomatedBackup()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineModel() != null) {
            sb.append("EngineModel: ").append(this.engineModel()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.engineAttributes() != null) {
            sb.append("EngineAttributes: ").append(this.engineAttributes()).append(",");
        }
        if (this.backupRetentionCount() != null) {
            sb.append("BackupRetentionCount: ").append(this.backupRetentionCount()).append(",");
        }
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.instanceProfileArn() != null) {
            sb.append("InstanceProfileArn: ").append(this.instanceProfileArn()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.keyPair() != null) {
            sb.append("KeyPair: ").append(this.keyPair()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.backupId() != null) {
            sb.append("BackupId: ").append(this.backupId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatePublicIpAddress": {
                return Optional.of(clazz.cast(this.associatePublicIpAddress()));
            }
            case "DisableAutomatedBackup": {
                return Optional.of(clazz.cast(this.disableAutomatedBackup()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineModel": {
                return Optional.of(clazz.cast(this.engineModel()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "EngineAttributes": {
                return Optional.of(clazz.cast(this.engineAttributes()));
            }
            case "BackupRetentionCount": {
                return Optional.of(clazz.cast(this.backupRetentionCount()));
            }
            case "ServerName": {
                return Optional.of(clazz.cast(this.serverName()));
            }
            case "InstanceProfileArn": {
                return Optional.of(clazz.cast(this.instanceProfileArn()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "KeyPair": {
                return Optional.of(clazz.cast(this.keyPair()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PreferredBackupWindow": {
                return Optional.of(clazz.cast(this.preferredBackupWindow()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "ServiceRoleArn": {
                return Optional.of(clazz.cast(this.serviceRoleArn()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "BackupId": {
                return Optional.of(clazz.cast(this.backupId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksCMRequest.BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private Boolean disableAutomatedBackup;
        private String engine;
        private String engineModel;
        private String engineVersion;
        private List<EngineAttribute> engineAttributes;
        private Integer backupRetentionCount;
        private String serverName;
        private String instanceProfileArn;
        private String instanceType;
        private String keyPair;
        private String preferredMaintenanceWindow;
        private String preferredBackupWindow;
        private List<String> securityGroupIds;
        private String serviceRoleArn;
        private List<String> subnetIds;
        private String backupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerRequest model) {
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.disableAutomatedBackup(model.disableAutomatedBackup);
            this.engine(model.engine);
            this.engineModel(model.engineModel);
            this.engineVersion(model.engineVersion);
            this.engineAttributes(model.engineAttributes);
            this.backupRetentionCount(model.backupRetentionCount);
            this.serverName(model.serverName);
            this.instanceProfileArn(model.instanceProfileArn);
            this.instanceType(model.instanceType);
            this.keyPair(model.keyPair);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.securityGroupIds(model.securityGroupIds);
            this.serviceRoleArn(model.serviceRoleArn);
            this.subnetIds(model.subnetIds);
            this.backupId(model.backupId);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Boolean getDisableAutomatedBackup() {
            return this.disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineModel() {
            return this.engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            return this.engineAttributes != null ? (Collection)this.engineAttributes.stream().map(EngineAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            this.engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        public final Integer getBackupRetentionCount() {
            return this.backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateServerRequest build() {
            return new CreateServerRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksCMRequest.Builder,
    CopyableBuilder<Builder, CreateServerRequest> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder disableAutomatedBackup(Boolean var1);

        public Builder engine(String var1);

        public Builder engineModel(String var1);

        public Builder engineVersion(String var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);

        public Builder backupRetentionCount(Integer var1);

        public Builder serverName(String var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder backupId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

