/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateServerEngineAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateServerEngineAttributesRequest> {
    private final String serverName;
    private final String attributeName;
    private final String attributeValue;

    private UpdateServerEngineAttributesRequest(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    public String serverName() {
        return this.serverName;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String attributeValue() {
        return this.attributeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serverName() == null ? 0 : this.serverName().hashCode());
        hashCode = 31 * hashCode + (this.attributeName() == null ? 0 : this.attributeName().hashCode());
        hashCode = 31 * hashCode + (this.attributeValue() == null ? 0 : this.attributeValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerEngineAttributesRequest)) {
            return false;
        }
        UpdateServerEngineAttributesRequest other = (UpdateServerEngineAttributesRequest)((Object)obj);
        if (other.serverName() == null ^ this.serverName() == null) {
            return false;
        }
        if (other.serverName() != null && !other.serverName().equals(this.serverName())) {
            return false;
        }
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.attributeValue() == null ^ this.attributeValue() == null) {
            return false;
        }
        return other.attributeValue() == null || other.attributeValue().equals(this.attributeValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.attributeValue() != null) {
            sb.append("AttributeValue: ").append(this.attributeValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.of(clazz.cast(this.serverName()));
            }
            case "AttributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
            case "AttributeValue": {
                return Optional.of(clazz.cast(this.attributeValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String serverName;
        private String attributeName;
        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServerEngineAttributesRequest model) {
            this.serverName(model.serverName);
            this.attributeName(model.attributeName);
            this.attributeValue(model.attributeValue);
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public UpdateServerEngineAttributesRequest build() {
            return new UpdateServerEngineAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateServerEngineAttributesRequest> {
        public Builder serverName(String var1);

        public Builder attributeName(String var1);

        public Builder attributeValue(String var1);
    }
}

