/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreServerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RestoreServerRequest> {
    private final String backupId;
    private final String serverName;
    private final String instanceType;
    private final String keyPair;

    private RestoreServerRequest(BuilderImpl builder) {
        this.backupId = builder.backupId;
        this.serverName = builder.serverName;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
    }

    public String backupId() {
        return this.backupId;
    }

    public String serverName() {
        return this.serverName;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String keyPair() {
        return this.keyPair;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.backupId() == null ? 0 : this.backupId().hashCode());
        hashCode = 31 * hashCode + (this.serverName() == null ? 0 : this.serverName().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.keyPair() == null ? 0 : this.keyPair().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreServerRequest)) {
            return false;
        }
        RestoreServerRequest other = (RestoreServerRequest)((Object)obj);
        if (other.backupId() == null ^ this.backupId() == null) {
            return false;
        }
        if (other.backupId() != null && !other.backupId().equals(this.backupId())) {
            return false;
        }
        if (other.serverName() == null ^ this.serverName() == null) {
            return false;
        }
        if (other.serverName() != null && !other.serverName().equals(this.serverName())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.keyPair() == null ^ this.keyPair() == null) {
            return false;
        }
        return other.keyPair() == null || other.keyPair().equals(this.keyPair());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backupId() != null) {
            sb.append("BackupId: ").append(this.backupId()).append(",");
        }
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.keyPair() != null) {
            sb.append("KeyPair: ").append(this.keyPair()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String backupId;
        private String serverName;
        private String instanceType;
        private String keyPair;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreServerRequest model) {
            this.setBackupId(model.backupId);
            this.setServerName(model.serverName);
            this.setInstanceType(model.instanceType);
            this.setKeyPair(model.keyPair);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public RestoreServerRequest build() {
            return new RestoreServerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreServerRequest> {
        public Builder backupId(String var1);

        public Builder serverName(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);
    }
}

