/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateServerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateServerRequest> {
    private final Boolean disableAutomatedBackup;
    private final Integer backupRetentionCount;
    private final String serverName;
    private final String preferredMaintenanceWindow;
    private final String preferredBackupWindow;

    private UpdateServerRequest(BuilderImpl builder) {
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
    }

    public Boolean disableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    public Integer backupRetentionCount() {
        return this.backupRetentionCount;
    }

    public String serverName() {
        return this.serverName;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.disableAutomatedBackup() == null ? 0 : this.disableAutomatedBackup().hashCode());
        hashCode = 31 * hashCode + (this.backupRetentionCount() == null ? 0 : this.backupRetentionCount().hashCode());
        hashCode = 31 * hashCode + (this.serverName() == null ? 0 : this.serverName().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.preferredBackupWindow() == null ? 0 : this.preferredBackupWindow().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerRequest)) {
            return false;
        }
        UpdateServerRequest other = (UpdateServerRequest)((Object)obj);
        if (other.disableAutomatedBackup() == null ^ this.disableAutomatedBackup() == null) {
            return false;
        }
        if (other.disableAutomatedBackup() != null && !other.disableAutomatedBackup().equals(this.disableAutomatedBackup())) {
            return false;
        }
        if (other.backupRetentionCount() == null ^ this.backupRetentionCount() == null) {
            return false;
        }
        if (other.backupRetentionCount() != null && !other.backupRetentionCount().equals(this.backupRetentionCount())) {
            return false;
        }
        if (other.serverName() == null ^ this.serverName() == null) {
            return false;
        }
        if (other.serverName() != null && !other.serverName().equals(this.serverName())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.preferredBackupWindow() == null ^ this.preferredBackupWindow() == null) {
            return false;
        }
        return other.preferredBackupWindow() == null || other.preferredBackupWindow().equals(this.preferredBackupWindow());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.disableAutomatedBackup() != null) {
            sb.append("DisableAutomatedBackup: ").append(this.disableAutomatedBackup()).append(",");
        }
        if (this.backupRetentionCount() != null) {
            sb.append("BackupRetentionCount: ").append(this.backupRetentionCount()).append(",");
        }
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean disableAutomatedBackup;
        private Integer backupRetentionCount;
        private String serverName;
        private String preferredMaintenanceWindow;
        private String preferredBackupWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServerRequest model) {
            this.setDisableAutomatedBackup(model.disableAutomatedBackup);
            this.setBackupRetentionCount(model.backupRetentionCount);
            this.setServerName(model.serverName);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setPreferredBackupWindow(model.preferredBackupWindow);
        }

        public final Boolean getDisableAutomatedBackup() {
            return this.disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        public final Integer getBackupRetentionCount() {
            return this.backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public UpdateServerRequest build() {
            return new UpdateServerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateServerRequest> {
        public Builder disableAutomatedBackup(Boolean var1);

        public Builder backupRetentionCount(Integer var1);

        public Builder serverName(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder preferredBackupWindow(String var1);
    }
}

