/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm;

import java.net.URI;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.auth.StaticSignerProvider;
import software.amazon.awssdk.client.builder.ClientBuilder;
import software.amazon.awssdk.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCMBaseClientBuilder;

@SdkInternalApi
abstract class DefaultOpsWorksCMBaseClientBuilder<B extends OpsWorksCMBaseClientBuilder<B, C>, C>
extends DefaultClientBuilder<B, C>
implements ClientBuilder<B, C> {
    DefaultOpsWorksCMBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "opsworks-cm";
    }

    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("/software/amazon/awssdk/services/opsworkscm/request.handler2s").defaultEndpoint(this::defaultEndpoint).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("opsworks-cm");
        signer.setRegionName(this.signingRegion().value());
        return new StaticSignerProvider((Signer)signer);
    }

    private URI defaultEndpoint() {
        return null;
    }
}

