/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.UserProfile;
import software.amazon.awssdk.services.opsworks.model.UserProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserProfilesResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeUserProfilesResponse> {
    private static final SdkField<List<UserProfile>> USER_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserProfiles").getter(DescribeUserProfilesResponse.getter(DescribeUserProfilesResponse::userProfiles)).setter(DescribeUserProfilesResponse.setter(Builder::userProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeUserProfilesResponse.memberNameToFieldInitializer();
    private final List<UserProfile> userProfiles;

    private DescribeUserProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.userProfiles = builder.userProfiles;
    }

    public final boolean hasUserProfiles() {
        return this.userProfiles != null && !(this.userProfiles instanceof SdkAutoConstructList);
    }

    public final List<UserProfile> userProfiles() {
        return this.userProfiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserProfiles() ? this.userProfiles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesResponse)) {
            return false;
        }
        DescribeUserProfilesResponse other = (DescribeUserProfilesResponse)((Object)obj);
        return this.hasUserProfiles() == other.hasUserProfiles() && Objects.equals(this.userProfiles(), other.userProfiles());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUserProfilesResponse").add("UserProfiles", this.hasUserProfiles() ? this.userProfiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserProfiles": {
                return Optional.ofNullable(clazz.cast(this.userProfiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<UserProfile>>> map = new HashMap<String, SdkField<List<UserProfile>>>();
        map.put("UserProfiles", USER_PROFILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfilesResponse, T> g) {
        return obj -> g.apply((DescribeUserProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<UserProfile> userProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesResponse model) {
            super(model);
            this.userProfiles(model.userProfiles);
        }

        public final List<UserProfile.Builder> getUserProfiles() {
            List<UserProfile.Builder> result = UserProfilesCopier.copyToBuilder(this.userProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserProfiles(Collection<UserProfile.BuilderImpl> userProfiles) {
            this.userProfiles = UserProfilesCopier.copyFromBuilder(userProfiles);
        }

        @Override
        public final Builder userProfiles(Collection<UserProfile> userProfiles) {
            this.userProfiles = UserProfilesCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfile ... userProfiles) {
            this.userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(Consumer<UserProfile.Builder> ... userProfiles) {
            this.userProfiles(Stream.of(userProfiles).map(c -> (UserProfile)((UserProfile.Builder)UserProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeUserProfilesResponse build() {
            return new DescribeUserProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserProfilesResponse> {
        public Builder userProfiles(Collection<UserProfile> var1);

        public Builder userProfiles(UserProfile ... var1);

        public Builder userProfiles(Consumer<UserProfile.Builder> ... var1);
    }
}

