/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVolumesRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeVolumesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(DescribeVolumesRequest.getter(DescribeVolumesRequest::instanceId)).setter(DescribeVolumesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(DescribeVolumesRequest.getter(DescribeVolumesRequest::stackId)).setter(DescribeVolumesRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> RAID_ARRAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RaidArrayId").getter(DescribeVolumesRequest.getter(DescribeVolumesRequest::raidArrayId)).setter(DescribeVolumesRequest.setter(Builder::raidArrayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidArrayId").build()}).build();
    private static final SdkField<List<String>> VOLUME_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VolumeIds").getter(DescribeVolumesRequest.getter(DescribeVolumesRequest::volumeIds)).setter(DescribeVolumesRequest.setter(Builder::volumeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, STACK_ID_FIELD, RAID_ARRAY_ID_FIELD, VOLUME_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVolumesRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String stackId;
    private final String raidArrayId;
    private final List<String> volumeIds;

    private DescribeVolumesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.raidArrayId = builder.raidArrayId;
        this.volumeIds = builder.volumeIds;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String raidArrayId() {
        return this.raidArrayId;
    }

    public final boolean hasVolumeIds() {
        return this.volumeIds != null && !(this.volumeIds instanceof SdkAutoConstructList);
    }

    public final List<String> volumeIds() {
        return this.volumeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.raidArrayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeIds() ? this.volumeIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesRequest)) {
            return false;
        }
        DescribeVolumesRequest other = (DescribeVolumesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.raidArrayId(), other.raidArrayId()) && this.hasVolumeIds() == other.hasVolumeIds() && Objects.equals(this.volumeIds(), other.volumeIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVolumesRequest").add("InstanceId", (Object)this.instanceId()).add("StackId", (Object)this.stackId()).add("RaidArrayId", (Object)this.raidArrayId()).add("VolumeIds", this.hasVolumeIds() ? this.volumeIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "RaidArrayId": {
                return Optional.ofNullable(clazz.cast(this.raidArrayId()));
            }
            case "VolumeIds": {
                return Optional.ofNullable(clazz.cast(this.volumeIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("StackId", STACK_ID_FIELD);
        map.put("RaidArrayId", RAID_ARRAY_ID_FIELD);
        map.put("VolumeIds", VOLUME_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumesRequest, T> g) {
        return obj -> g.apply((DescribeVolumesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String stackId;
        private String raidArrayId;
        private List<String> volumeIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.stackId(model.stackId);
            this.raidArrayId(model.raidArrayId);
            this.volumeIds(model.volumeIds);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getRaidArrayId() {
            return this.raidArrayId;
        }

        public final void setRaidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
        }

        @Override
        public final Builder raidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
            return this;
        }

        public final Collection<String> getVolumeIds() {
            if (this.volumeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.volumeIds;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = StringsCopier.copy(volumeIds);
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = StringsCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String ... volumeIds) {
            this.volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumesRequest build() {
            return new DescribeVolumesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVolumesRequest> {
        public Builder instanceId(String var1);

        public Builder stackId(String var1);

        public Builder raidArrayId(String var1);

        public Builder volumeIds(Collection<String> var1);

        public Builder volumeIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

