/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterRdsDbInstanceRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, RegisterRdsDbInstanceRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(RegisterRdsDbInstanceRequest.getter(RegisterRdsDbInstanceRequest::stackId)).setter(RegisterRdsDbInstanceRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> RDS_DB_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RdsDbInstanceArn").getter(RegisterRdsDbInstanceRequest.getter(RegisterRdsDbInstanceRequest::rdsDbInstanceArn)).setter(RegisterRdsDbInstanceRequest.setter(Builder::rdsDbInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstanceArn").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(RegisterRdsDbInstanceRequest.getter(RegisterRdsDbInstanceRequest::dbUser)).setter(RegisterRdsDbInstanceRequest.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbPassword").getter(RegisterRdsDbInstanceRequest.getter(RegisterRdsDbInstanceRequest::dbPassword)).setter(RegisterRdsDbInstanceRequest.setter(Builder::dbPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, RDS_DB_INSTANCE_ARN_FIELD, DB_USER_FIELD, DB_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterRdsDbInstanceRequest.memberNameToFieldInitializer();
    private final String stackId;
    private final String rdsDbInstanceArn;
    private final String dbUser;
    private final String dbPassword;

    private RegisterRdsDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String rdsDbInstanceArn() {
        return this.rdsDbInstanceArn;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final String dbPassword() {
        return this.dbPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterRdsDbInstanceRequest)) {
            return false;
        }
        RegisterRdsDbInstanceRequest other = (RegisterRdsDbInstanceRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.rdsDbInstanceArn(), other.rdsDbInstanceArn()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.dbPassword(), other.dbPassword());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterRdsDbInstanceRequest").add("StackId", (Object)this.stackId()).add("RdsDbInstanceArn", (Object)this.rdsDbInstanceArn()).add("DbUser", (Object)this.dbUser()).add("DbPassword", (Object)this.dbPassword()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "RdsDbInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.rdsDbInstanceArn()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "DbPassword": {
                return Optional.ofNullable(clazz.cast(this.dbPassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("StackId", STACK_ID_FIELD);
        map.put("RdsDbInstanceArn", RDS_DB_INSTANCE_ARN_FIELD);
        map.put("DbUser", DB_USER_FIELD);
        map.put("DbPassword", DB_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterRdsDbInstanceRequest, T> g) {
        return obj -> g.apply((RegisterRdsDbInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String rdsDbInstanceArn;
        private String dbUser;
        private String dbPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterRdsDbInstanceRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.rdsDbInstanceArn(model.rdsDbInstanceArn);
            this.dbUser(model.dbUser);
            this.dbPassword(model.dbPassword);
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getRdsDbInstanceArn() {
            return this.rdsDbInstanceArn;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getDbPassword() {
            return this.dbPassword;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterRdsDbInstanceRequest build() {
            return new RegisterRdsDbInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterRdsDbInstanceRequest> {
        public Builder stackId(String var1);

        public Builder rdsDbInstanceArn(String var1);

        public Builder dbUser(String var1);

        public Builder dbPassword(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

