/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeConfiguration> {
    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountPoint").getter(VolumeConfiguration.getter(VolumeConfiguration::mountPoint)).setter(VolumeConfiguration.setter(Builder::mountPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoint").build()}).build();
    private static final SdkField<Integer> RAID_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RaidLevel").getter(VolumeConfiguration.getter(VolumeConfiguration::raidLevel)).setter(VolumeConfiguration.setter(Builder::raidLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidLevel").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfDisks").getter(VolumeConfiguration.getter(VolumeConfiguration::numberOfDisks)).setter(VolumeConfiguration.setter(Builder::numberOfDisks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDisks").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Size").getter(VolumeConfiguration.getter(VolumeConfiguration::size)).setter(VolumeConfiguration.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(VolumeConfiguration.getter(VolumeConfiguration::volumeType)).setter(VolumeConfiguration.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(VolumeConfiguration.getter(VolumeConfiguration::iops)).setter(VolumeConfiguration.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(VolumeConfiguration.getter(VolumeConfiguration::encrypted)).setter(VolumeConfiguration.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOUNT_POINT_FIELD, RAID_LEVEL_FIELD, NUMBER_OF_DISKS_FIELD, SIZE_FIELD, VOLUME_TYPE_FIELD, IOPS_FIELD, ENCRYPTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VolumeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mountPoint;
    private final Integer raidLevel;
    private final Integer numberOfDisks;
    private final Integer size;
    private final String volumeType;
    private final Integer iops;
    private final Boolean encrypted;

    private VolumeConfiguration(BuilderImpl builder) {
        this.mountPoint = builder.mountPoint;
        this.raidLevel = builder.raidLevel;
        this.numberOfDisks = builder.numberOfDisks;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.encrypted = builder.encrypted;
    }

    public final String mountPoint() {
        return this.mountPoint;
    }

    public final Integer raidLevel() {
        return this.raidLevel;
    }

    public final Integer numberOfDisks() {
        return this.numberOfDisks;
    }

    public final Integer size() {
        return this.size;
    }

    public final String volumeType() {
        return this.volumeType;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.raidLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDisks());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration)obj;
        return Objects.equals(this.mountPoint(), other.mountPoint()) && Objects.equals(this.raidLevel(), other.raidLevel()) && Objects.equals(this.numberOfDisks(), other.numberOfDisks()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.encrypted(), other.encrypted());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeConfiguration").add("MountPoint", (Object)this.mountPoint()).add("RaidLevel", (Object)this.raidLevel()).add("NumberOfDisks", (Object)this.numberOfDisks()).add("Size", (Object)this.size()).add("VolumeType", (Object)this.volumeType()).add("Iops", (Object)this.iops()).add("Encrypted", (Object)this.encrypted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MountPoint": {
                return Optional.ofNullable(clazz.cast(this.mountPoint()));
            }
            case "RaidLevel": {
                return Optional.ofNullable(clazz.cast(this.raidLevel()));
            }
            case "NumberOfDisks": {
                return Optional.ofNullable(clazz.cast(this.numberOfDisks()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MountPoint", MOUNT_POINT_FIELD);
        map.put("RaidLevel", RAID_LEVEL_FIELD);
        map.put("NumberOfDisks", NUMBER_OF_DISKS_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeConfiguration, T> g) {
        return obj -> g.apply((VolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mountPoint;
        private Integer raidLevel;
        private Integer numberOfDisks;
        private Integer size;
        private String volumeType;
        private Integer iops;
        private Boolean encrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            this.mountPoint(model.mountPoint);
            this.raidLevel(model.raidLevel);
            this.numberOfDisks(model.numberOfDisks);
            this.size(model.size);
            this.volumeType(model.volumeType);
            this.iops(model.iops);
            this.encrypted(model.encrypted);
        }

        public final String getMountPoint() {
            return this.mountPoint;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final Integer getRaidLevel() {
            return this.raidLevel;
        }

        public final void setRaidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
        }

        @Override
        public final Builder raidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
            return this;
        }

        public final Integer getNumberOfDisks() {
            return this.numberOfDisks;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final Integer getSize() {
            return this.size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeConfiguration> {
        public Builder mountPoint(String var1);

        public Builder raidLevel(Integer var1);

        public Builder numberOfDisks(Integer var1);

        public Builder size(Integer var1);

        public Builder volumeType(String var1);

        public Builder iops(Integer var1);

        public Builder encrypted(Boolean var1);
    }
}

